package ru.yandex.direct.intapi.entity.moderation.model;

import java.util.List;
import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;

import ru.yandex.direct.core.entity.user.model.UsersBlockReasonType;

public class BlockClientsRequest {
    @JsonProperty("client_ids")
    private final List<Long> clientIds;
    @JsonProperty("ignore_sanity_checks")
    private final boolean ignoreSanityChecks;
    @JsonProperty("block_reason_type")
    private final UsersBlockReasonType blockReasonType;
    @JsonProperty("block_comment")
    private final String blockComment;

    public BlockClientsRequest(@JsonProperty("client_ids") List<Long> clientIds,
                               @JsonProperty("ignore_sanity_checks") Boolean ignoreSanityChecks,
                               @JsonProperty("block_reason_type") UsersBlockReasonType blockReasonType,
                               @JsonProperty("block_comment") String blockComment) {
        this.clientIds = Objects.requireNonNull(clientIds);
        this.ignoreSanityChecks = MoreObjects.firstNonNull(ignoreSanityChecks, false);
        this.blockReasonType = blockReasonType;
        this.blockComment = blockComment;
    }

    public List<Long> getClientIds() {
        return clientIds;
    }

    public boolean isIgnoreSanityChecks() {
        return ignoreSanityChecks;
    }

    public UsersBlockReasonType getBlockReasonType() {
        return blockReasonType;
    }

    public String getBlockComment() {
        return blockComment;
    }
}
