package ru.yandex.direct.intapi.entity.moderation.model;

import java.util.List;
import java.util.Objects;

import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

@ParametersAreNonnullByDefault
@JsonInclude(JsonInclude.Include.NON_NULL)
public class BlockClientsResponse {

    @JsonProperty("results")
    List<BlockClientResult> results;

    @JsonProperty("error")
    String error;

    public BlockClientsResponse() {
    }

    public BlockClientsResponse(List<BlockClientResult> results) {
        this.results = results;
    }

    public BlockClientsResponse(String error) {
        this.error = error;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        BlockClientsResponse that = (BlockClientsResponse) o;
        return results.equals(that.results);
    }

    @Override
    public int hashCode() {
        return Objects.hash(results);
    }

    public List<BlockClientResult> getResults() {
        return results;
    }

    @Override
    public String toString() {
        return "BlockClientsResponse{" +
                "results=" + results +
                '}';
    }
}
