package ru.yandex.direct.intapi.entity.moderation.model;

import java.util.Map;
import java.util.Set;

import javax.annotation.Nonnull;

import com.fasterxml.jackson.annotation.JsonProperty;
import org.jetbrains.annotations.Nullable;


public class CidAndDomainInfo {
    @JsonProperty("cid")
    private Long cid;

    @JsonProperty("domain")
    private String domain;

    @JsonProperty("flags")
    private Set<String> flags;

    @JsonProperty("minus_geo_info")
    private Map<String, Set<Long>> minusGeoByType;

    public CidAndDomainInfo(@Nonnull Long cid,
                            @Nonnull String domain,
                            @Nullable Set<String> flags,
                            @Nullable Map<String, Set<Long>> minusGeoByType) {
        this.cid = cid;
        this.domain = domain;
        this.flags = flags;
        this.minusGeoByType = minusGeoByType;
    }

    public Long getCid() {
        return cid;
    }

    public void setCid(Long cid) {
        this.cid = cid;
    }

    public String getDomain() {
        return domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public Set<String> getFlags() {
        return flags;
    }

    public void setFlags(Set<String> flags) {
        this.flags = flags;
    }

    public Map<String, Set<Long>> getMinusGeoByType() {
        return minusGeoByType;
    }

    public void setMinusGeoByType(Map<String, Set<Long>> minusGeoByType) {
        this.minusGeoByType = minusGeoByType;
    }
}
