package ru.yandex.direct.intapi.entity.moderation.model;

import java.util.Objects;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

@ParametersAreNonnullByDefault
@JsonInclude(JsonInclude.Include.NON_NULL)
public class UnblockClientResult {

    @JsonProperty("client_id")
    protected Long clientId;

    @JsonProperty("previous_block_status")
    protected ClientBlockStatus previousBlockStatus;

    @JsonProperty("error")
    protected String error;

    public UnblockClientResult() {
    }

    public UnblockClientResult(Long clientId,
                               ClientBlockStatus previousBlockStatus,
                               @Nullable String error) {
        this.clientId = clientId;
        this.previousBlockStatus = previousBlockStatus;
        this.error = error;
    }

    public UnblockClientResult(Long clientId,
                               ClientBlockStatus previousBlockStatus) {
        this.clientId = clientId;
        this.previousBlockStatus = previousBlockStatus;
    }

    public UnblockClientResult(Long clientId,
                               @Nullable String error) {
        this.clientId = clientId;
        this.error = error;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        UnblockClientResult that = (UnblockClientResult) o;
        return Objects.equals(clientId, that.clientId) && previousBlockStatus == that.previousBlockStatus
                && Objects.equals(error, that.error);
    }

    @Override
    public int hashCode() {
        return Objects.hash(clientId, previousBlockStatus, error);
    }

    @Override
    public String toString() {
        return "UnblockClientResult{" +
                "clientId=" + clientId +
                ", previousBlockStatus=" + previousBlockStatus +
                '}';
    }
}
