package ru.yandex.direct.intapi.entity.moderation.model;

import java.util.List;
import java.util.Objects;

import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

@ParametersAreNonnullByDefault
@JsonInclude(JsonInclude.Include.NON_NULL)
public class UnblockClientsResponse {

    @JsonProperty("results")
    List<UnblockClientResult> results;

    @JsonProperty("error")
    String error;

    public UnblockClientsResponse() {
    }

    public UnblockClientsResponse(List<UnblockClientResult> results) {
        this.results = results;
    }

    public UnblockClientsResponse(String error) {
        this.error = error;
    }

    public List<UnblockClientResult> getResults() {
        return results;
    }

    public String getError() {
        return error;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        UnblockClientsResponse that = (UnblockClientsResponse) o;
        return Objects.equals(results, that.results) && Objects.equals(error, that.error);
    }

    @Override
    public int hashCode() {
        return Objects.hash(results, error);
    }

    @Override
    public String toString() {
        return "UnblockClientsResponse{" +
                "results=" + results +
                '}';
    }
}
