package ru.yandex.direct.intapi.entity.moderation.model.client;

import java.util.Map;

import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.direct.intapi.validation.model.IntapiValidationResponse;
import ru.yandex.direct.intapi.validation.model.IntapiValidationResult;

public class ModerationClientsResponse extends IntapiValidationResponse {

    // ClientID -> params
    @JsonProperty("client_params")
    private Map<Long, ModerationClientParams> clientParamsMap;

    public ModerationClientsResponse(IntapiValidationResult intapiValidationResult) {
        super(intapiValidationResult);
    }

    public ModerationClientsResponse(Map<Long, ModerationClientParams> clientParamsMap) {
        super(new IntapiValidationResult());
        this.clientParamsMap = clientParamsMap;
    }

    public Map<Long, ModerationClientParams> getClientParamsMap() {
        return clientParamsMap;
    }
}
