package ru.yandex.direct.intapi.entity.moderation.model.modedit;

import java.util.ArrayList;
import java.util.List;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.direct.intapi.validation.model.IntapiValidationResult;

@JsonInclude(JsonInclude.Include.NON_NULL)
public class ModerationEditObjectResult {

    private Long id;

    private ModerationEditType type;

    private ModerationEditStatus editStatus;

    private List<ModerationEditFieldResult> fieldResults;

    private IntapiValidationResult validationResult;

    public ModerationEditObjectResult() {
    }

    public ModerationEditObjectResult(Long id,
                                      ModerationEditType type,
                                      ModerationEditStatus editStatus,
                                      List<ModerationEditFieldResult> fieldResults,
                                      IntapiValidationResult validationResult) {
        this.id = id;
        this.type = type;
        this.editStatus = editStatus;
        this.fieldResults = fieldResults;
        this.validationResult = validationResult;
    }

    public ModerationEditObjectResult(Long id, ModerationEditType type) {
        this(id, type, null, null, null);
    }

    public ModerationEditObjectResult(Long id, ModerationEditType type, ModerationEditStatus editStatus) {
        this(id, type, editStatus, null, null);
    }

    public ModerationEditObjectResult(Long id, ModerationEditType type, IntapiValidationResult validationResult) {
        this(id, type, ModerationEditStatus.VALIDATION_ERROR, null, validationResult);
    }

    public static ModerationEditObjectResult notFound(Long id, ModerationEditType type) {
        return new ModerationEditObjectResult(id, type, ModerationEditStatus.NOT_FOUND);
    }

    public static ModerationEditObjectResult badStatusModerate(Long id, ModerationEditType type) {
        return new ModerationEditObjectResult(id, type, ModerationEditStatus.NOT_APPLICABLE_STATUS_MODERATE);
    }

    @JsonProperty("id")
    public Long getId() {
        return this.id;
    }

    @JsonProperty("type")
    public ModerationEditType getType() {
        return this.type;
    }

    @JsonProperty("edit_status")
    public ModerationEditStatus getEditStatus() {
        return this.editStatus;
    }

    public void setEditStatus(ModerationEditStatus editStatus) {
        this.editStatus = editStatus;
    }

    @JsonProperty("fields")
    public List<ModerationEditFieldResult> getFieldResults() {
        return this.fieldResults;
    }

    public void addFieldResult(String field, ModerationEditFieldStatus status) {
        if (null == fieldResults) {
            fieldResults = new ArrayList<>();
        }
        this.fieldResults.add(new ModerationEditFieldResult(field, status));
    }

    @JsonProperty("validation_result")
    public IntapiValidationResult getValidationResult() {
        return this.validationResult;
    }
}
