package ru.yandex.direct.intapi.entity.moderation.model.modedit;

import java.util.List;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.direct.intapi.validation.model.IntapiValidationResult;

@JsonInclude(JsonInclude.Include.NON_NULL)
public class ModerationEditObjectsResult {

    private List<ModerationEditObjectResult> results;

    private IntapiValidationResult validationResult;

    public ModerationEditObjectsResult() {
    }

    public ModerationEditObjectsResult(IntapiValidationResult validationResult) {
        this.results = null;
        this.validationResult = validationResult;
    }

    public ModerationEditObjectsResult(List<ModerationEditObjectResult> results) {
        this.results = results;
        this.validationResult = null;
    }

    @JsonProperty("results")
    public List<ModerationEditObjectResult> getResults() {
        return this.results;
    }

    @JsonProperty("validation_result")
    public IntapiValidationResult getValidationResult() {
        return this.validationResult;
    }
}
