package ru.yandex.direct.intapi.entity.moderationreason.controller;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import ru.yandex.direct.core.entity.moderationreason.model.ModerationReportResponse;
import ru.yandex.direct.core.entity.moderationreason.service.ModerationReasonAggregatorService;
import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.intapi.ErrorResponse;
import ru.yandex.direct.intapi.IntApiException;
import ru.yandex.direct.intapi.logging.ClientIdParam;
import ru.yandex.direct.intapi.logging.OperatorUid;
import ru.yandex.direct.tvm.AllowServices;

import static ru.yandex.direct.core.entity.moderationreason.service.ModerationDiagConverter.stringToLongList;

@RestController
@RequestMapping("moderationreason")
@Api(tags = "moderationreason")
@AllowServices(production = {})
public class ModerationReasonController {

    private final ModerationReasonAggregatorService moderationReasonAggregatorService;

    @Autowired
    public ModerationReasonController(
            ModerationReasonAggregatorService moderationReasonAggregatorService) {
        this.moderationReasonAggregatorService = moderationReasonAggregatorService;
    }

    @ApiOperation(value = "Возврат причин отклонения",
            response = ModerationReportResponse.class)
    @RequestMapping(value = "showDiags", method = RequestMethod.GET,
            consumes = MediaType.APPLICATION_JSON_VALUE)
    public ModerationReportResponse showDiags(
            @RequestParam(value = "creative_rejection_reason_ids", required = false) String creativeRejectionReasonIds,
            @RequestParam(value = "additions_item_ids", required = false) String additionsItemIds,
            @RequestParam(value = "bid", required = false) Long bannerId,
            @RequestParam(value = "operator_uid") @OperatorUid Long operatorUid,
            @RequestParam(value = "client_id") @ClientIdParam Long clientId) {
        final var banner = moderationReasonAggregatorService.showDiags(operatorUid,
                ClientId.fromLong(clientId),
                stringToLongList(creativeRejectionReasonIds),
                stringToLongList(additionsItemIds),
                bannerId);

        if (banner.isEmpty()) {
            throw new IntApiException(HttpStatus.FORBIDDEN,
                    new ErrorResponse(ErrorResponse.ErrorCode.PERMISSION_DENIED, "Permission denied"));
        }

        return banner.get();
    }
}
