package ru.yandex.direct.intapi.entity.notification.controller;


import java.util.HashSet;
import java.util.List;
import java.util.Set;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

import ru.yandex.direct.common.net.NetworkName;
import ru.yandex.direct.core.entity.urlmonitoring.service.UrlMonitoringService;
import ru.yandex.direct.intapi.ErrorResponse;
import ru.yandex.direct.intapi.entity.notification.model.UrlMonitoringNotificationResponse;
import ru.yandex.direct.web.core.security.netacl.AllowNetworks;

/**
 *
 */
@RestController
@RequestMapping("notification")
@AllowNetworks({NetworkName.DIRECT_PRODUCTION})
@Api(tags = "intapiNotification")
public class NotificationController {

    private final UrlMonitoringService urlMonitoringService;

    @Autowired
    public NotificationController(UrlMonitoringService urlMonitoringService) {
        this.urlMonitoringService = urlMonitoringService;
    }

    @ApiOperation(
            value = "intapiUrlMonitoringNotification",
            httpMethod = "GET",
            nickname = "intapiUrlMonitoringNotification"
    )
    @ApiResponses(
            {
                    @ApiResponse(code = 400, message = "Bad params", response = ErrorResponse.class),
                    @ApiResponse(code = 200, message = "Ok", response = UrlMonitoringNotificationResponse.class)
            }
    )
    @RequestMapping(path = "/urlmonitoring",
            method = RequestMethod.POST,
            consumes = MediaType.APPLICATION_JSON_UTF8_VALUE,
            produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    @ResponseBody
    public UrlMonitoringNotificationResponse getUrlMonitoringNotification(
            @RequestBody Set<String> urlsToCheck) {
        List<String> deadUrls = urlMonitoringService.getDeadUrls(urlsToCheck);
        return new UrlMonitoringNotificationResponse()
                .withDeadUrls(new HashSet<>(deadUrls));
    }

}
