package ru.yandex.direct.intapi.entity.offerretargeting.presentation

import ru.yandex.direct.core.entity.offerretargeting.validation.OfferRetargetingDefects.Gen.OFFER_RETARGETING_ALREADY_DELETED
import ru.yandex.direct.core.entity.offerretargeting.validation.OfferRetargetingDefects.Gen.OFFER_RETARGETING_ALREADY_SUSPENDED
import ru.yandex.direct.core.entity.offerretargeting.validation.OfferRetargetingDefects.Gen.OFFER_RETARGETING_CANT_BE_USED_IN_AUTO_BUDGET_CAMPAIGN
import ru.yandex.direct.core.entity.offerretargeting.validation.OfferRetargetingDefects.Gen.OFFER_RETARGETING_NOT_SUSPENDED
import ru.yandex.direct.core.entity.offerretargeting.validation.OfferRetargetingDefects.Number.TOO_MANY_OFFER_RETARGETINGS_IN_AD_GROUP
import ru.yandex.direct.intapi.validation.kernel.IntapiDefectPresentationProviders.defaultIntapiDefect
import ru.yandex.direct.intapi.validation.kernel.TranslatableIntapiDefect
import ru.yandex.direct.validation.presentation.DefaultDefectPresentationRegistry

object OfferRetargetingDefectPresentations {
    @JvmStatic
    fun offerRetargetingDefectPresentationRegistry(): DefaultDefectPresentationRegistry<TranslatableIntapiDefect> {
        return DefaultDefectPresentationRegistry.builder()
            .register(OFFER_RETARGETING_CANT_BE_USED_IN_AUTO_BUDGET_CAMPAIGN, defaultIntapiDefect())
            .register(OFFER_RETARGETING_ALREADY_DELETED, defaultIntapiDefect())
            .register(OFFER_RETARGETING_ALREADY_SUSPENDED, defaultIntapiDefect())
            .register(OFFER_RETARGETING_NOT_SUSPENDED, defaultIntapiDefect())
            .register(TOO_MANY_OFFER_RETARGETINGS_IN_AD_GROUP, defaultIntapiDefect())
            .build()
    }
}
