package ru.yandex.direct.intapi.entity.organization.model;

import java.util.Set;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;

@ParametersAreNonnullByDefault
public class OrganizationsCheckAccessRequest {
    @JsonProperty("permalinkIds")
    private final Set<Long> permalinkIds;
    @JsonProperty("uids")
    private final Set<Long> uids;

    public OrganizationsCheckAccessRequest(@JsonProperty("permalinkIds") Set<Long> permalinkIds,
                                           @JsonProperty("uids") Set<Long> uids) {
        Preconditions.checkNotNull(permalinkIds);
        permalinkIds.forEach(Preconditions::checkNotNull);
        Preconditions.checkNotNull(uids);
        uids.forEach(Preconditions::checkNotNull);

        this.permalinkIds = ImmutableSet.copyOf(permalinkIds);
        this.uids = ImmutableSet.copyOf(uids);
    }

    @Nonnull
    public Set<Long> getPermalinkIds() {
        return permalinkIds;
    }

    @Nonnull
    public Set<Long> getUids() {
        return uids;
    }
}
