package ru.yandex.direct.intapi.entity.organization.model;

import java.util.Set;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;

@ParametersAreNonnullByDefault
public class OrganizationsInfoRequest {
    @JsonProperty("permalinkIds")
    private final Set<Long> permalinkIds;

    @JsonProperty("language")
    private final String languageName;

    public OrganizationsInfoRequest(@JsonProperty("permalinkIds") Set<Long> permalinkIds,
                                    @JsonProperty("language") String languageName) {
        Preconditions.checkNotNull(permalinkIds);
        permalinkIds.forEach(Preconditions::checkNotNull);
        Preconditions.checkNotNull(languageName);
        this.permalinkIds = ImmutableSet.copyOf(permalinkIds);
        this.languageName = languageName;
    }

    @Nonnull
    public Set<Long> getPermalinkIds() {
        return permalinkIds;
    }

    @Nonnull
    public String getLanguageName() {
        return languageName;
    }
}
