package ru.yandex.direct.intapi.entity.payment.model;

import java.math.BigDecimal;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

public class GetPaymentFormUrlOrInvoiceIdRequest {
    @JsonProperty("login")
    @Nullable
    private final String login;

    @JsonProperty("uid")
    @Nullable
    private final Long uid;

    @JsonProperty(value = "legal_entity", required = true)
    @Nonnull
    private final Boolean isLegalPerson;

    @JsonProperty(value = "is_invoice_payment", required = true)
    @Nonnull
    private final Boolean isInvoicePayment;

    @JsonProperty("paysys_id")
    @Nullable
    private final Long paysysId;

    @JsonProperty(value = "payment_sum", required = true)
    @Nonnull
    private final BigDecimal paymentSum;

    @JsonProperty("promocode")
    @Nullable
    private final String promocode;

    @JsonCreator
    public GetPaymentFormUrlOrInvoiceIdRequest(
            @Nullable @JsonProperty("login") String login,
            @Nullable @JsonProperty("uid") Long uid,
            @Nonnull @JsonProperty("legal_entity") Boolean isLegalPerson,
            @Nonnull @JsonProperty("is_invoice") Boolean isInvoicePayment,
            @Nullable @JsonProperty("paysys_id") Long paysysId,
            @Nonnull @JsonProperty("payment_sum") BigDecimal paymentSum,
            @Nullable @JsonProperty("promocode") String promocode) {
        this.login = login;
        this.uid = uid;
        this.isLegalPerson = isLegalPerson;
        this.isInvoicePayment = isInvoicePayment;
        this.paysysId = paysysId;
        this.paymentSum = paymentSum;
        this.promocode = promocode;
    }

    @Nullable
    public String getLogin() {
        return login;
    }

    @Nullable
    public Long getUid() {
        return uid;
    }

    @Nonnull
    public Boolean getIsLegalPerson() {
        return isLegalPerson;
    }

    @Nonnull
    public Boolean getIsInvoicePayment() {
        return isInvoicePayment;
    }

    @Nullable
    public Long getPaysysId() {
        return paysysId;
    }

    @Nonnull
    public BigDecimal getPaymentSum() {
        return paymentSum;
    }

    @Nullable
    public String getPromocode() {
        return promocode;
    }
}
