package ru.yandex.direct.intapi.entity.payment.model;

import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.direct.web.core.model.WebSuccessResponse;

public class GetPaymentFormUrlOrInvoiceIdResponse extends WebSuccessResponse {
    private String paymentUrl;
    private String mobilePaymentUrl;
    private Long invoiceId;

    @JsonProperty("payment_url")
    public String getPaymentUrl() {
        return paymentUrl;
    }

    public GetPaymentFormUrlOrInvoiceIdResponse withPaymentUrl(String paymentUrl) {
        this.paymentUrl = paymentUrl;
        return this;
    }

    @JsonProperty("mobile_payment_url")
    public String getMobilePaymentUrl() {
        return mobilePaymentUrl;
    }

    public GetPaymentFormUrlOrInvoiceIdResponse withMobilePaymentUrl(String mobilePaymentUrl) {
        this.mobilePaymentUrl = mobilePaymentUrl;
        return this;
    }

    @JsonProperty("invoice_id")
    public Long getInvoiceId() {
        return invoiceId;
    }

    public GetPaymentFormUrlOrInvoiceIdResponse withInvoiceId(Long invoiceId) {
        this.invoiceId = invoiceId;
        return this;
    }
}
