package ru.yandex.direct.intapi.entity.payment.model;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

public class GetPaymentMethodsRequest {
    @JsonProperty("login")
    @Nullable
    private final String login;

    @JsonProperty("uid")
    @Nullable
    private final Long uid;

    @JsonProperty(value = "legal_entity", required = true)
    @Nonnull
    private final Boolean isLegalPerson;

    @JsonCreator
    public GetPaymentMethodsRequest(
            @Nullable @JsonProperty("login") String login,
            @Nullable @JsonProperty("uid") Long uid,
            @Nonnull @JsonProperty("legal_entity") Boolean isLegalPerson) {
        this.login = login;
        this.uid = uid;
        this.isLegalPerson = isLegalPerson;
    }

    @Nullable
    public String getLogin() {
        return login;
    }

    @Nullable
    public Long getUid() {
        return uid;
    }

    @Nonnull
    public Boolean getIsLegalPerson() {
        return isLegalPerson;
    }
}
