package ru.yandex.direct.intapi.entity.payment.model;

import java.math.BigDecimal;
import java.util.Set;

import com.fasterxml.jackson.annotation.JsonProperty;

public class PaymentMethod {
    private String code;
    private Set<String> disabledReasons;
    private Long id;
    private Boolean legalEntity;
    private String name;
    private BigDecimal paymentLimit;
    private String paymentMethodCode;
    private Long paymentMethodId;
    private String paymentMethodName;
    private Long regionId;
    private Boolean resident;

    @JsonProperty("code")
    public String getCode() {
        return code;
    }

    public PaymentMethod withCode(String code) {
        this.code = code;
        return this;
    }

    @JsonProperty("disabled_reasons")
    public Set<String> getDisabledReasons() {
        return disabledReasons;
    }

    public PaymentMethod withDisabledReasons(Set<String> disabledReasons) {
        this.disabledReasons = disabledReasons;
        return this;
    }

    @JsonProperty("paysys_id")
    public Long getId() {
        return id;
    }

    public PaymentMethod withId(Long id) {
        this.id = id;
        return this;
    }

    @JsonProperty("legal_entity")
    public Boolean getLegalEntity() {
        return legalEntity;
    }

    public PaymentMethod withLegalEntity(Boolean legalEntity) {
        this.legalEntity = legalEntity;
        return this;
    }

    @JsonProperty("name")
    public String getName() {
        return name;
    }

    public PaymentMethod withName(String name) {
        this.name = name;
        return this;
    }

    @JsonProperty("payment_limit")
    public BigDecimal getPaymentLimit() {
        return paymentLimit;
    }

    public PaymentMethod withPaymentLimit(BigDecimal paymentLimit) {
        this.paymentLimit = paymentLimit;
        return this;
    }

    @JsonProperty("payment_method_code")
    public String getPaymentMethodCode() {
        return paymentMethodCode;

    }

    public PaymentMethod withPaymentMethodCode(String paymentMethodCode) {
        this.paymentMethodCode = paymentMethodCode;
        return this;
    }

    @JsonProperty("payment_method_id")
    public Long getPaymentMethodId() {
        return paymentMethodId;
    }

    public PaymentMethod withPaymentMethodId(Long paymentMethodId) {
        this.paymentMethodId = paymentMethodId;
        return this;
    }

    @JsonProperty("payment_method_name")
    public String getPaymentMethodName() {
        return paymentMethodName;
    }

    public PaymentMethod withPaymentMethodName(String paymentMethodName) {
        this.paymentMethodName = paymentMethodName;
        return this;
    }

    @JsonProperty("region_id")
    public Long getRegionId() {
        return regionId;
    }

    public PaymentMethod withRegionId(Long regionId) {
        this.regionId = regionId;
        return this;
    }

    @JsonProperty("resident")
    public Boolean getResident() {
        return resident;
    }

    public PaymentMethod withResident(Boolean resident) {
        this.resident = resident;
        return this;
    }
}
