package ru.yandex.direct.intapi.entity.pricepackage.presentation;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.entity.pricepackage.service.validation.defects.PricePackageDefectIds;
import ru.yandex.direct.intapi.validation.kernel.TranslatableIntapiDefect;
import ru.yandex.direct.validation.presentation.DefaultDefectPresentationRegistry;

import static ru.yandex.direct.intapi.validation.kernel.IntapiDefectPresentationProviders.defaultIntapiDefect;

@ParametersAreNonnullByDefault
public class PricePackageDefectPresentations {

    private PricePackageDefectPresentations() {
    }

    public static DefaultDefectPresentationRegistry<TranslatableIntapiDefect>
    pricePackagesDefectPresentationRegistry() {
        return DefaultDefectPresentationRegistry.builder()
                .register(PricePackageDefectIds.Gen.CLIENT_CURRENCY_NOT_EQUALS_PACKAGE_CURRENCY,
                        defaultIntapiDefect())
                .register(PricePackageDefectIds.Gen.GEO_EXPANDED_IS_EMPTY,
                        defaultIntapiDefect())
                .register(PricePackageDefectIds.Gen.PRICE_PACKAGE_IS_EXPIRED,
                        defaultIntapiDefect())
                .register(PricePackageDefectIds.Gen.CRYPTA_TYPES_COUNT_IS_MISMATCHED,
                        defaultIntapiDefect())
                .register(PricePackageDefectIds.Gen.CREATIVE_TEMPLATES_IS_EMPTY,
                        defaultIntapiDefect())
                .register(PricePackageDefectIds.Gen.CREATIVE_TEMPLATES_AND_AD_GROUP_TYPES_MISMATCHED,
                        defaultIntapiDefect())
                .register(PricePackageDefectIds.DateTime.USER_TIMESTAMP_NOT_EQUALS_LAST_UPDATE_TIME,
                        defaultIntapiDefect())
                .register(PricePackageDefectIds.Gen.MUTUAL_EXCLUSIVE_BID_MODIFIERS_SELECTED,
                        defaultIntapiDefect())
                .register(PricePackageDefectIds.Gen.DATE_START_CAN_ONLY_EXPAND,
                        defaultIntapiDefect())
                .register(PricePackageDefectIds.Gen.DATE_END_CAN_ONLY_EXPAND,
                        defaultIntapiDefect())
                .register(PricePackageDefectIds.Gen.CREATIVE_TEMPLATES_CAN_ONLY_EXPAND,
                        defaultIntapiDefect())
                .register(PricePackageDefectIds.Gen.RETARGETING_CATEGORIES_AMOUNT_LESS_LOWER_LIMIT,
                        defaultIntapiDefect())
                .register(PricePackageDefectIds.Gen.RETARGETING_CATEGORIES_AMOUNT_GREATER_UPPER_LIMIT,
                        defaultIntapiDefect())
                .register(PricePackageDefectIds.Gen.OVERLAPPING_PRICE_MARKUPS,
                        defaultIntapiDefect())

                .build();
    }

}
