package ru.yandex.direct.intapi.entity.promocodes.controller;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import ru.yandex.direct.core.entity.promocodes.service.PromocodesAntiFraudService;
import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.intapi.ErrorResponse;
import ru.yandex.direct.intapi.entity.promocodes.model.PromocodeDomainsAddParameters;
import ru.yandex.direct.tvm.AllowServices;

import static ru.yandex.direct.tvm.TvmService.COMDEP_CHECK_FRAUD;
import static ru.yandex.direct.tvm.TvmService.DIRECT_DEVELOPER;

@RestController
@RequestMapping("promocodedomains")
@Api(tags = "promocodeDomains")
@AllowServices(
        production = {COMDEP_CHECK_FRAUD},
        testing = {COMDEP_CHECK_FRAUD, DIRECT_DEVELOPER}
)
public class PromocodeDomainsController {
    private final PromocodesAntiFraudService service;

    @Autowired
    public PromocodeDomainsController(PromocodesAntiFraudService service) {
        this.service = service;
    }

    @ApiOperation(value = "Записать промокод и связанные с ним домен и id клиента")
    @PostMapping(value = "add")
    @ApiResponses(
            {
                    @ApiResponse(code = 400, message = "Bad request", response = ErrorResponse.class),
                    @ApiResponse(code = 204, message = "Added"),
            }
    )
    public ResponseEntity<Void> add(@RequestBody PromocodeDomainsAddParameters request) {
        if (shouldReturnBadRequest(request)) {
            return new ResponseEntity<>(HttpStatus.BAD_REQUEST);
        }
        service.addPromocodeDomain(
                request.getPromocode(),
                ClientId.fromLong(request.getClientId()), request.getDomain()
        );
        return new ResponseEntity<>(HttpStatus.NO_CONTENT);
    }

    private boolean shouldReturnBadRequest(PromocodeDomainsAddParameters request) {
        return request.getClientId() <= 0
                || StringUtils.isBlank(request.getDomain())
                || StringUtils.isBlank(request.getPromocode());
    }
}
