package ru.yandex.direct.intapi.entity.promocodes.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

@ApiModel
@JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.ANY,
        getterVisibility = JsonAutoDetect.Visibility.NONE,
        setterVisibility = JsonAutoDetect.Visibility.NONE,
        creatorVisibility = JsonAutoDetect.Visibility.NONE
)
public class PromocodeDomainsAddParameters {
    @JsonProperty(value = "Promocode", required = true)
    @ApiModelProperty(value = "Текст промокода", required = true, example = "DIRE-CTPR-OMOC-ODE1")
    private String promocode;

    @JsonProperty(value = "Domain", required = true)
    @ApiModelProperty(value = "Домен", required = true, example = "kupislona.co.uk")
    private String domain;

    @JsonProperty(value = "ClientID", required = true)
    @ApiModelProperty(value = "Идентификатор клиента", required = true, example = "456789")
    private long clientId;

    public String getPromocode() {
        return promocode;
    }

    public PromocodeDomainsAddParameters withPromocode(String promocode) {
        this.promocode = promocode;
        return this;
    }

    public String getDomain() {
        return domain;
    }

    public PromocodeDomainsAddParameters withDomain(String domain) {
        this.domain = domain;
        return this;
    }

    public long getClientId() {
        return clientId;
    }

    public PromocodeDomainsAddParameters withClientId(long clientId) {
        this.clientId = clientId;
        return this;
    }
}
