package ru.yandex.direct.intapi.entity.recommendation.controller;


import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

import ru.yandex.direct.common.net.NetworkName;
import ru.yandex.direct.common.spring.TestingComponent;
import ru.yandex.direct.intapi.ErrorResponse;
import ru.yandex.direct.intapi.entity.recommendation.controller.model.Recommendation;
import ru.yandex.direct.intapi.entity.recommendation.controller.service.RecommendationInsertService;
import ru.yandex.direct.web.core.model.WebResponse;
import ru.yandex.direct.web.core.model.WebSuccessResponse;
import ru.yandex.direct.web.core.security.netacl.AllowNetworks;

/**
 * Ручка для создания рекомендаций в тестовых целях для интеграционного тестирования.
 * Будет вызываться при тестировании фронта, чтобы проверить правильное отображение и применение рекомендаций.
 */
@RestController
@RequestMapping("recommendation")
@AllowNetworks({NetworkName.DIRECT_PRODUCTION})
@TestingComponent
public class RecommendationController {

    private RecommendationInsertService recommendationInsertService;

    @Autowired
    public RecommendationController(RecommendationInsertService recommendationInsertService) {
        this.recommendationInsertService = recommendationInsertService;
    }

    @ApiOperation(
            value = "intapiCreateRecommendation",
            httpMethod = "POST",
            nickname = "intapiCreateRecommendation"
    )
    @ApiResponses(
            {
                    @ApiResponse(code = 400, message = "Bad params", response = ErrorResponse.class),
                    @ApiResponse(code = 200, message = "Ok", response = WebSuccessResponse.class)
            }
    )
    @RequestMapping(path = "/create",
            method = RequestMethod.POST,
            consumes = MediaType.APPLICATION_JSON_UTF8_VALUE)
    @ResponseBody
    public WebResponse createRecommendation(@RequestBody Recommendation rec) {
        return recommendationInsertService.createRecommendation(rec);
    }
}
