package ru.yandex.direct.intapi.entity.recommendation.controller.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;

@JsonIgnoreProperties(ignoreUnknown = true)
public class Recommendation {
    private static final String CLIENT_ID = "client_id";
    private static final String TYPE = "type";
    private static final String CID = "cid";
    private static final String PID = "pid";
    private static final String BID = "bid";
    private static final String USER_KEY_1 = "user_key_1";
    private static final String USER_KEY_2 = "user_key_2";
    private static final String USER_KEY_3 = "user_key_3";
    private static final String TIMESTAMP = "timestamp";
    private static final String DATA = "data";

    @JsonProperty(CLIENT_ID)
    @ApiModelProperty(required = true)
    private Long clientId;

    @JsonProperty(TYPE)
    @ApiModelProperty(required = true)
    private Long type;

    @JsonProperty(CID)
    @ApiModelProperty(required = true)
    private Long cid;

    @JsonProperty(PID)
    @ApiModelProperty(required = true)
    private Long pid;

    @JsonProperty(BID)
    @ApiModelProperty(required = true)
    private Long bid;

    @JsonProperty(USER_KEY_1)
    @ApiModelProperty(required = true)
    private String userKey1;

    @JsonProperty(USER_KEY_2)
    @ApiModelProperty(required = true)
    private String userKey2;

    @JsonProperty(USER_KEY_3)
    @ApiModelProperty(required = true)
    private String userKey3;

    @JsonProperty(TIMESTAMP)
    @ApiModelProperty()
    private Long timestamp;

    @JsonProperty(DATA)
    @ApiModelProperty(required = true)
    private String data;

    public Long getClientId() {
        return clientId;
    }

    public void setClientId(Long clientId) {
        this.clientId = clientId;
    }

    public Long getType() {
        return type;
    }

    public void setType(Long type) {
        this.type = type;
    }

    public Long getCid() {
        return cid;
    }

    public void setCid(Long cid) {
        this.cid = cid;
    }

    public Long getPid() {
        return pid;
    }

    public void setPid(Long pid) {
        this.pid = pid;
    }

    public Long getBid() {
        return bid;
    }

    public void setBid(Long bid) {
        this.bid = bid;
    }

    public String getUserKey1() {
        return userKey1;
    }

    public void setUserKey1(String userKey1) {
        this.userKey1 = userKey1;
    }

    public String getUserKey2() {
        return userKey2;
    }

    public void setUserKey2(String userKey2) {
        this.userKey2 = userKey2;
    }

    public String getUserKey3() {
        return userKey3;
    }

    public void setUserKey3(String userKey3) {
        this.userKey3 = userKey3;
    }

    public Long getTimestamp() {
        return timestamp;
    }

    public void setTimestamp(Long timestamp) {
        this.timestamp = timestamp;
    }

    public String getData() {
        return data;
    }

    public void setData(String data) {
        this.data = data;
    }
}
