package ru.yandex.direct.intapi.entity.region.presentation;

import ru.yandex.direct.core.validation.CommonDefectTranslations;
import ru.yandex.direct.i18n.types.DummyTranslatable;
import ru.yandex.direct.intapi.validation.kernel.TranslatableIntapiDefect;
import ru.yandex.direct.validation.presentation.DefaultDefectPresentationRegistry;

import static ru.yandex.direct.core.entity.region.validation.RegionIdDefectIds.Gen.EMPTY_REGIONS;
import static ru.yandex.direct.core.entity.region.validation.RegionIdDefectIds.Gen.INCORRECT_USE_OF_ZERO_REGION;
import static ru.yandex.direct.core.entity.region.validation.RegionIdDefectIds.Gen.NO_PLUS_REGIONS;
import static ru.yandex.direct.core.entity.region.validation.RegionIdDefectIds.RegionIds.INCORRECT_REGIONS;
import static ru.yandex.direct.core.entity.region.validation.RegionIdDefectIds.RegionIds.MINUS_REGION_MATCHES_PLUS_REGION;
import static ru.yandex.direct.core.entity.region.validation.RegionIdDefectIds.Regions.GEO_FRONTPAGE_BROWSER_NEW_TAB_IGNORED_REGIONS_DUE_TO_PRICE;
import static ru.yandex.direct.core.entity.region.validation.RegionIdDefectIds.Regions.GEO_FRONTPAGE_DESKTOP_IGNORED_REGIONS_DUE_TO_PRICE;
import static ru.yandex.direct.core.entity.region.validation.RegionIdDefectIds.Regions.GEO_FRONTPAGE_MOBILE_IGNORED_REGIONS_DUE_TO_PRICE;
import static ru.yandex.direct.core.entity.region.validation.RegionIdDefectIds.Regions.MINUS_REGIONS_WITHOUT_PLUS_REGIONS;
import static ru.yandex.direct.core.entity.region.validation.RegionIdDefectIds.Regions.NON_UNIQUE_REGIONS;
import static ru.yandex.direct.intapi.validation.kernel.IntapiDefectPresentationProviders.intapiDefect;
import static ru.yandex.direct.intapi.validation.kernel.IntapiDefectPresentationProviders.paramIntapiDefect;

public class RegionDefectPresentations {

    private RegionDefectPresentations() {
    }

    public static DefaultDefectPresentationRegistry<TranslatableIntapiDefect> regionDefectPresentationRegistry() {
        CommonDefectTranslations translations = CommonDefectTranslations.INSTANCE;

        return DefaultDefectPresentationRegistry.builder()
                .register(EMPTY_REGIONS,
                        intapiDefect(translations.badGeoDetailedEmptyRegions()))
                .register(INCORRECT_USE_OF_ZERO_REGION,
                        intapiDefect(translations.badGeoDetailedIncorrectUseOfZeroRegion()))
                .register(NO_PLUS_REGIONS,
                        intapiDefect(translations.badGeoDetailedNoPlusRegions()))
                .register(INCORRECT_REGIONS,
                        paramIntapiDefect(di -> translations.badGeoDetailedIncorrectRegions(
                                di.getDefect().params().getRegionIds())))
                .register(MINUS_REGION_MATCHES_PLUS_REGION,
                        paramIntapiDefect(di -> translations.badGeoDetailedMinusRegionMatchesPlusRegion(
                                di.getDefect().params().getMinusRegionIds(),
                                di.getDefect().params().getRegionIds())))
                .register(MINUS_REGIONS_WITHOUT_PLUS_REGIONS,
                        paramIntapiDefect(di -> translations.badGeoDetailedMinusRegionsWithoutPlusRegions(
                                new DummyTranslatable(di.getDefect().params().toIdsString()))))
                .register(NON_UNIQUE_REGIONS,
                        paramIntapiDefect(di -> translations.badGeoDetailedNonUniqueRegions(
                                new DummyTranslatable(di.getDefect().params().toIdsString()))))
                .register(GEO_FRONTPAGE_DESKTOP_IGNORED_REGIONS_DUE_TO_PRICE,
                        paramIntapiDefect(di -> translations.regionsIgnoredDesktopBecauseOfPrice(
                                new DummyTranslatable(di.getDefect().params().toIdsString()))))
                .register(GEO_FRONTPAGE_MOBILE_IGNORED_REGIONS_DUE_TO_PRICE,
                        paramIntapiDefect(di -> translations.regionsIgnoredMobileBecauseOfPrice(
                                new DummyTranslatable(di.getDefect().params().toIdsString()))))
                .register(GEO_FRONTPAGE_BROWSER_NEW_TAB_IGNORED_REGIONS_DUE_TO_PRICE,
                        paramIntapiDefect(di -> translations.regionsIgnoredBrowserNewTabBecauseOfPrice(
                                new DummyTranslatable(di.getDefect().params().toIdsString()))))

                .build();
    }
}
