package ru.yandex.direct.intapi.entity.relevancematch.presentation;

import ru.yandex.direct.intapi.validation.kernel.TranslatableIntapiDefect;
import ru.yandex.direct.validation.presentation.DefaultDefectPresentationRegistry;

import static ru.yandex.direct.core.entity.relevancematch.valdiation.RelevanceMatchDefects.Gen.RELEVANCE_MATCH_ALREADY_DELETED;
import static ru.yandex.direct.core.entity.relevancematch.valdiation.RelevanceMatchDefects.Gen.RELEVANCE_MATCH_ALREADY_SUSPENDED;
import static ru.yandex.direct.core.entity.relevancematch.valdiation.RelevanceMatchDefects.Gen.RELEVANCE_MATCH_CANT_BE_DELETED_FROM_ADGROUP_WITHOUT_PHRASES;
import static ru.yandex.direct.core.entity.relevancematch.valdiation.RelevanceMatchDefects.Gen.RELEVANCE_MATCH_CANT_BE_USED_IN_AUTO_BUDGET_COMPANY;
import static ru.yandex.direct.core.entity.relevancematch.valdiation.RelevanceMatchDefects.Gen.RELEVANCE_MATCH_CANT_BE_USED_WHEN_SEARCH_IS_STOPPED;
import static ru.yandex.direct.core.entity.relevancematch.valdiation.RelevanceMatchDefects.Gen.RELEVANCE_MATCH_NOT_SUSPENDED;
import static ru.yandex.direct.core.entity.relevancematch.valdiation.RelevanceMatchDefects.Number.TOO_MANY_RELEVANCE_MATCH_IN_AD_GROUP;
import static ru.yandex.direct.intapi.validation.kernel.IntapiDefectPresentationProviders.defaultIntapiDefect;

public class RelevanceMatchDefectPresentations {

    private RelevanceMatchDefectPresentations() {
    }

    public static DefaultDefectPresentationRegistry<TranslatableIntapiDefect>
    relevanceMatchDefectPresentationRegistry() {
        return DefaultDefectPresentationRegistry.builder()
                .register(RELEVANCE_MATCH_CANT_BE_USED_IN_AUTO_BUDGET_COMPANY, defaultIntapiDefect())
                .register(RELEVANCE_MATCH_CANT_BE_USED_WHEN_SEARCH_IS_STOPPED, defaultIntapiDefect())
                .register(RELEVANCE_MATCH_ALREADY_DELETED, defaultIntapiDefect())
                .register(RELEVANCE_MATCH_CANT_BE_DELETED_FROM_ADGROUP_WITHOUT_PHRASES, defaultIntapiDefect())
                .register(RELEVANCE_MATCH_ALREADY_SUSPENDED, defaultIntapiDefect())
                .register(RELEVANCE_MATCH_NOT_SUSPENDED, defaultIntapiDefect())
                .register(TOO_MANY_RELEVANCE_MATCH_IN_AD_GROUP, defaultIntapiDefect())
                .build();
    }
}
