package ru.yandex.direct.intapi.entity.retargeting.presentation;

import ru.yandex.direct.core.entity.retargeting.service.validation2.RetargetingDefectTranslations;
import ru.yandex.direct.core.validation.CommonDefectTranslations;
import ru.yandex.direct.core.validation.defects.params.ModelIdDefectParams;
import ru.yandex.direct.i18n.types.Identity;
import ru.yandex.direct.intapi.validation.kernel.TranslatableIntapiDefect;
import ru.yandex.direct.validation.presentation.DefaultDefectPresentationRegistry;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.DefectInfo;

import static ru.yandex.direct.core.entity.retargeting.Constants.MAX_INTEREST_RULES_PER_CONDITION;
import static ru.yandex.direct.core.entity.retargeting.service.validation2.RetargetingDefectIds.FieldRequirements.LEAST_ONE_FIELD_REQUIRED;
import static ru.yandex.direct.core.entity.retargeting.service.validation2.RetargetingDefectIds.FieldRequirements.MUTUALLY_EXCLUSIVE_PARAMETERS;
import static ru.yandex.direct.core.entity.retargeting.service.validation2.RetargetingDefectIds.Gen.ABSENT_IDS_IN_SELECTION;
import static ru.yandex.direct.core.entity.retargeting.service.validation2.RetargetingDefectIds.Gen.ALL_CRYPTA_GOALS_MUST_HAVE_SAME_TYPE;
import static ru.yandex.direct.core.entity.retargeting.service.validation2.RetargetingDefectIds.Gen.ALL_GOALS_MUST_BE_EITHER_FROM_METRIKA_OR_CRYPTA;
import static ru.yandex.direct.core.entity.retargeting.service.validation2.RetargetingDefectIds.Gen.ALL_SOCIAL_DEMO_GOALS_MUST_HAVE_SAME_PARENT_ID;
import static ru.yandex.direct.core.entity.retargeting.service.validation2.RetargetingDefectIds.Gen.AUDIENCE_NOT_FOUND;
import static ru.yandex.direct.core.entity.retargeting.service.validation2.RetargetingDefectIds.Gen.AUDIENCE_TARGET_ALLOWED_IN_MOBILE_CONTENT_CAMPAIGN;
import static ru.yandex.direct.core.entity.retargeting.service.validation2.RetargetingDefectIds.Gen.CANNOT_CHANGE_RETARGETING_SCOPE;
import static ru.yandex.direct.core.entity.retargeting.service.validation2.RetargetingDefectIds.Gen.CPM_YNDX_FRONTPAGE_RETARGETINGS_NOT_ALLOWED;
import static ru.yandex.direct.core.entity.retargeting.service.validation2.RetargetingDefectIds.Gen.CRYPTA_GOALS_ALLOWED_ONLY_FOR_INTERESTS_TYPE;
import static ru.yandex.direct.core.entity.retargeting.service.validation2.RetargetingDefectIds.Gen.CRYPTA_GOALS_ALLOWED_ONLY_FOR_OR_CONDITION;
import static ru.yandex.direct.core.entity.retargeting.service.validation2.RetargetingDefectIds.Gen.DUPLICATED_GOAL;
import static ru.yandex.direct.core.entity.retargeting.service.validation2.RetargetingDefectIds.Gen.DUPLICATED_OBJECT_WITH_NAME;
import static ru.yandex.direct.core.entity.retargeting.service.validation2.RetargetingDefectIds.Gen.DUPLICATED_OBJECT_WITH_RULES;
import static ru.yandex.direct.core.entity.retargeting.service.validation2.RetargetingDefectIds.Gen.DUPLICATED_RETARGETING_CONDITION_ID;
import static ru.yandex.direct.core.entity.retargeting.service.validation2.RetargetingDefectIds.Gen.DUPLICATED_RETARGETING_CONDITION_ID_FOR_ADGROUP_ID;
import static ru.yandex.direct.core.entity.retargeting.service.validation2.RetargetingDefectIds.Gen.DUPLICATED_RETARGETING_ID;
import static ru.yandex.direct.core.entity.retargeting.service.validation2.RetargetingDefectIds.Gen.INCONSISTENT_RETARGETING_CONDITION_BY_DEFAULT_ADGROUP;
import static ru.yandex.direct.core.entity.retargeting.service.validation2.RetargetingDefectIds.Gen.INCONSISTENT_STATE_TARGETING_CATEGORY;
import static ru.yandex.direct.core.entity.retargeting.service.validation2.RetargetingDefectIds.Gen.INTERESTS_TYPE_IS_NOT_SPECIFIED;
import static ru.yandex.direct.core.entity.retargeting.service.validation2.RetargetingDefectIds.Gen.INTEREST_LIMIT_EXCEEDED;
import static ru.yandex.direct.core.entity.retargeting.service.validation2.RetargetingDefectIds.Gen.INVALID_GOALS_FOR_TYPE;
import static ru.yandex.direct.core.entity.retargeting.service.validation2.RetargetingDefectIds.Gen.INVALID_RETARGETING_CONDITION;
import static ru.yandex.direct.core.entity.retargeting.service.validation2.RetargetingDefectIds.Gen.INVALID_RETARGETING_CONDITION_BY_PRICE_PACKAGE;
import static ru.yandex.direct.core.entity.retargeting.service.validation2.RetargetingDefectIds.Gen.INVALID_RETARGETING_CONDITION_IN_USER_PROFILE_FOR_TGO;
import static ru.yandex.direct.core.entity.retargeting.service.validation2.RetargetingDefectIds.Gen.INVALID_USE_OF_FIELD_EXTRA_FIELD_FOR_GOAL_OR_SEGMENT;
import static ru.yandex.direct.core.entity.retargeting.service.validation2.RetargetingDefectIds.Gen.LIMIT_MUST_BE_GREATER_THAN_ZERO;
import static ru.yandex.direct.core.entity.retargeting.service.validation2.RetargetingDefectIds.Gen.MAX_IDS_IN_SELECTION;
import static ru.yandex.direct.core.entity.retargeting.service.validation2.RetargetingDefectIds.Gen.MUST_CONTAIN_POSITIVE_ELEMENT;
import static ru.yandex.direct.core.entity.retargeting.service.validation2.RetargetingDefectIds.Gen.MUST_NOT_CONTAIN_ALL_ELEMENTS;
import static ru.yandex.direct.core.entity.retargeting.service.validation2.RetargetingDefectIds.Gen.NOT_ELIGABLE_ADGROUP;
import static ru.yandex.direct.core.entity.retargeting.service.validation2.RetargetingDefectIds.Gen.NOT_FOUND;
import static ru.yandex.direct.core.entity.retargeting.service.validation2.RetargetingDefectIds.Gen.NO_NEEDED_PARAMS_IN_SELECTION;
import static ru.yandex.direct.core.entity.retargeting.service.validation2.RetargetingDefectIds.Gen.NO_RIGHTS_IN_ARCHIVED_ADGROUP;
import static ru.yandex.direct.core.entity.retargeting.service.validation2.RetargetingDefectIds.Gen.OFFSET_MUST_BE_POSITIVE;
import static ru.yandex.direct.core.entity.retargeting.service.validation2.RetargetingDefectIds.Gen.REQUIRED_TIME_FOR_GOAL_OR_SEGMENT;
import static ru.yandex.direct.core.entity.retargeting.service.validation2.RetargetingDefectIds.Gen.RETARGETING_CONDITION_ALREADY_EXISTS;
import static ru.yandex.direct.core.entity.retargeting.service.validation2.RetargetingDefectIds.Gen.RETARGETING_CONDITION_NOT_FOUND;
import static ru.yandex.direct.core.entity.retargeting.service.validation2.RetargetingDefectIds.Gen.UNSUPPORTED_GOAL_ID;
import static ru.yandex.direct.core.entity.retargeting.service.validation2.RetargetingDefectIds.Gen.WARNING_ALREADY_SUSPENDED;
import static ru.yandex.direct.core.entity.retargeting.service.validation2.RetargetingDefectIds.Gen.WARNING_DUPLICATED_RETARGETING_ID;
import static ru.yandex.direct.core.entity.retargeting.service.validation2.RetargetingDefectIds.Gen.WARNING_NOT_SUSPENDED;
import static ru.yandex.direct.core.entity.retargeting.service.validation2.RetargetingDefectIds.IdParametrized.ADGROUP_NOT_FOUND;
import static ru.yandex.direct.core.entity.retargeting.service.validation2.RetargetingDefectIds.IdParametrized.CAMPAIGN_STATUS_ARCHIVED_ON_ADD;
import static ru.yandex.direct.core.entity.retargeting.service.validation2.RetargetingDefectIds.IdParametrized.CAMPAIGN_STATUS_ARCHIVED_ON_DELETE;
import static ru.yandex.direct.core.entity.retargeting.service.validation2.RetargetingDefectIds.IdParametrized.CAMPAIGN_STATUS_ARCHIVED_ON_RESUME;
import static ru.yandex.direct.core.entity.retargeting.service.validation2.RetargetingDefectIds.IdParametrized.CAMPAIGN_STATUS_ARCHIVED_ON_SUSPEND;
import static ru.yandex.direct.core.entity.retargeting.service.validation2.RetargetingDefectIds.IdParametrized.RETARGETING_CONDITION_NOT_FOUND_WITH_ID;
import static ru.yandex.direct.core.entity.retargeting.service.validation2.RetargetingDefectIds.Nums.LIMIT_MUST_BE_LESS_THAN_VALUE;
import static ru.yandex.direct.core.entity.retargeting.service.validation2.RetargetingDefectIds.Nums.MAX_SIZE_IN_ADGROUP;
import static ru.yandex.direct.core.entity.retargeting.service.validation2.RetargetingDefectIds.Nums.MAX_SIZE_IN_CPM_ADGROUP;
import static ru.yandex.direct.core.entity.retargeting.service.validation2.RetargetingDefectIds.Nums.MAX_SIZE_USER_PROFILE_IN_CPM_ADGROUP;
import static ru.yandex.direct.intapi.validation.kernel.IntapiDefectPresentationProviders.defaultIntapiDefect;
import static ru.yandex.direct.intapi.validation.kernel.IntapiDefectPresentationProviders.intapiDefect;
import static ru.yandex.direct.intapi.validation.kernel.IntapiDefectPresentationProviders.paramIntapiDefect;

public class RetargetingDefectPresentations {

    private RetargetingDefectPresentations() {
    }

    public static DefaultDefectPresentationRegistry<TranslatableIntapiDefect> retargetingDefectPresentationRegistry() {
        CommonDefectTranslations translations = CommonDefectTranslations.INSTANCE;
        RetargetingDefectTranslations retTranslations = RetargetingDefectTranslations.INSTANCE;

        return DefaultDefectPresentationRegistry.builder()
                .register(MAX_IDS_IN_SELECTION,
                        defaultIntapiDefect())
                .register(LIMIT_MUST_BE_LESS_THAN_VALUE,
                        defaultIntapiDefect())
                .register(LIMIT_MUST_BE_GREATER_THAN_ZERO,
                        defaultIntapiDefect())
                .register(OFFSET_MUST_BE_POSITIVE,
                        defaultIntapiDefect())
                .register(NO_NEEDED_PARAMS_IN_SELECTION,
                        defaultIntapiDefect())
                .register(REQUIRED_TIME_FOR_GOAL_OR_SEGMENT,
                        intapiDefect(translations.requiredButEmptyShort()))
                .register(INVALID_USE_OF_FIELD_EXTRA_FIELD_FOR_GOAL_OR_SEGMENT,
                        defaultIntapiDefect())
                .register(INVALID_GOALS_FOR_TYPE,
                        intapiDefect(translations.invalidGoalsForTypeNoneDetailed()))
                .register(CANNOT_CHANGE_RETARGETING_SCOPE,
                        intapiDefect(translations.errorRetargetingScopeChange()))
                .register(ABSENT_IDS_IN_SELECTION,
                        defaultIntapiDefect())
                .register(DUPLICATED_RETARGETING_CONDITION_ID,
                        intapiDefect(translations.duplicatedRetargetingConditionId()))
                .register(DUPLICATED_OBJECT_WITH_NAME,
                        intapiDefect(translations.duplicatedObjectNameDetailed()))
                .register(AUDIENCE_NOT_FOUND,
                        intapiDefect(translations.audienceTargetNotFound()))
                .register(DUPLICATED_RETARGETING_ID,
                        intapiDefect(translations.duplicatedRetargetingId()))
                .register(NOT_FOUND,
                        intapiDefect(translations.notFoundRetargetingDetailed()))

                .register(ALL_GOALS_MUST_BE_EITHER_FROM_METRIKA_OR_CRYPTA,
                        intapiDefect(translations.allGoalsAreEitherFromMetrikaOrCrypta()))
                .register(CRYPTA_GOALS_ALLOWED_ONLY_FOR_INTERESTS_TYPE,
                        intapiDefect(translations.cryptaGoalsAllowedOnlyForInterestsType()))
                .register(CRYPTA_GOALS_ALLOWED_ONLY_FOR_OR_CONDITION,
                        intapiDefect(translations.cryptaGoalsAllowedOnlyForOrCondition()))
                .register(INTERESTS_TYPE_IS_NOT_SPECIFIED,
                        intapiDefect(translations.interestsTypeIsNotSpecified()))
                .register(ALL_CRYPTA_GOALS_MUST_HAVE_SAME_TYPE,
                        intapiDefect(translations.allCryptaGoalsMustHaveSameType()))
                .register(ALL_SOCIAL_DEMO_GOALS_MUST_HAVE_SAME_PARENT_ID,
                        intapiDefect(translations.allSocialDemoGoalsMustHaveSameParentId()))
                .register(MUST_NOT_CONTAIN_ALL_ELEMENTS,
                        intapiDefect(translations.mustNotContainAllElements()))
                .register(UNSUPPORTED_GOAL_ID,
                        intapiDefect(retTranslations.unsupportedGoalId()))
                .register(MUST_CONTAIN_POSITIVE_ELEMENT,
                        intapiDefect(translations.allElementsAreNegative()))
                .register(INTEREST_LIMIT_EXCEEDED,
                        intapiDefect(translations.interestLimitExceeded(MAX_INTEREST_RULES_PER_CONDITION)))
                .register(CPM_YNDX_FRONTPAGE_RETARGETINGS_NOT_ALLOWED,
                        intapiDefect(retTranslations.cpmYndxFrontpageRetargetingsNotAllowed()))
                .register(INVALID_RETARGETING_CONDITION_IN_USER_PROFILE_FOR_TGO,
                        intapiDefect(translations.invalidRetargetingConditionInUserProfileInTgo()))

                .register(DUPLICATED_GOAL,
                        intapiDefect(translations.duplicatedGoal()))
                .register(RETARGETING_CONDITION_ALREADY_EXISTS,
                        intapiDefect(translations.retargetingConditionAlreadyExists()))
                .register(INVALID_RETARGETING_CONDITION,
                        intapiDefect(translations.retargetingConditionIsInvalidForRetargeting()))
                .register(INVALID_RETARGETING_CONDITION_BY_PRICE_PACKAGE,
                        intapiDefect(translations.retargetingConditionIsInvalidForPricePackage()))
                .register(INCONSISTENT_RETARGETING_CONDITION_BY_DEFAULT_ADGROUP,
                        intapiDefect(translations.retargetingConditionIsInvalidForDefaultAdGroup()))
                .register(RETARGETING_CONDITION_NOT_FOUND,
                        intapiDefect(translations.retargetingConditionNotFoundDetailed()))
                .register(RETARGETING_CONDITION_NOT_FOUND_WITH_ID,
                        paramIntapiDefect(di -> translations.retargetingConditionNotFoundDetailedWithId(
                                modelIdIdentity(di))))
                .register(INCONSISTENT_STATE_TARGETING_CATEGORY,
                        intapiDefect(translations.inconsistentStateTargetingCategoryUnavailable()))
                .register(NOT_ELIGABLE_ADGROUP,
                        intapiDefect(translations.notEligibleAdGroupDetailed()))
                .register(DUPLICATED_RETARGETING_CONDITION_ID_FOR_ADGROUP_ID,
                        intapiDefect(translations.duplicatedRetargetingConditionIdForAdGroupId()))
                .register(MAX_SIZE_IN_ADGROUP,
                        paramIntapiDefect(di -> translations.adGroupLimitExceeded(
                                new Identity(di.getDefect().params().getMax().longValue()))))
                .register(MAX_SIZE_IN_CPM_ADGROUP,
                        intapiDefect(translations.cpmAdGroupLimitExceeded()))
                .register(MAX_SIZE_USER_PROFILE_IN_CPM_ADGROUP,
                        intapiDefect(translations.adGroupUserProfileLimitExceeded()))
                .register(MUTUALLY_EXCLUSIVE_PARAMETERS,
                        paramIntapiDefect(di -> translations.mutuallyExclusiveParametersTwoElements(
                                di.getDefect().params().getPath1(), di.getDefect().params().getPath2())))
                .register(LEAST_ONE_FIELD_REQUIRED,
                        paramIntapiDefect(di -> translations.requiredAtLeastOneOfFieldsTwoElements(
                                di.getDefect().params().getPath1(), di.getDefect().params().getPath2())))

                .register(WARNING_NOT_SUSPENDED,
                        intapiDefect(translations.notSuspendedRetargetingDetailed()))
                .register(WARNING_ALREADY_SUSPENDED,
                        intapiDefect(translations.alreadySuspendedRetargetingDetailed()))
                .register(WARNING_DUPLICATED_RETARGETING_ID,
                        intapiDefect(translations.duplicatedRetargetingId()))
                .register(ADGROUP_NOT_FOUND,
                        paramIntapiDefect(di -> translations.adGroupNotFoundDetailed(
                                modelIdIdentity(di))))
                .register(NO_RIGHTS_IN_ARCHIVED_ADGROUP,
                        intapiDefect(retTranslations.retargetingModificationInArchivedAdGroup()))
                .register(AUDIENCE_TARGET_ALLOWED_IN_MOBILE_CONTENT_CAMPAIGN,
                        intapiDefect(retTranslations.audienceTargetAllowedInMobileContentCampaign()))
                .register(CAMPAIGN_STATUS_ARCHIVED_ON_ADD,
                        paramIntapiDefect(di -> translations.badCampaignStatusArchived(
                                modelIdIdentity(di))))
                .register(CAMPAIGN_STATUS_ARCHIVED_ON_DELETE,
                        paramIntapiDefect(di -> translations.cantRemoveAudienceTargetFromArchivedCampaignDetailed(
                                modelIdIdentity(di))))
                .register(CAMPAIGN_STATUS_ARCHIVED_ON_SUSPEND,
                        paramIntapiDefect(di -> translations.badCampaignStatusArchivedOnSuspend(
                                modelIdIdentity(di))))
                .register(CAMPAIGN_STATUS_ARCHIVED_ON_RESUME,
                        paramIntapiDefect(di -> translations.badCampaignStatusArchivedOnResume(
                                modelIdIdentity(di))))

                .register(DUPLICATED_OBJECT_WITH_RULES,
                        intapiDefect(translations.duplicatedRetConditionRulesDetailed()))

                .build();
    }

    private static Identity modelIdIdentity(DefectInfo<? extends Defect<ModelIdDefectParams>> defect) {
        return new Identity(defect.getDefect().params().getId());
    }
}
