package ru.yandex.direct.intapi.entity.retargeting.presentation;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.entity.retargeting.model.Goal;
import ru.yandex.direct.core.entity.retargeting.model.RetargetingCondition;
import ru.yandex.direct.core.entity.retargeting.model.Rule;
import ru.yandex.direct.validation.result.MappingPathNodeConverter;
import ru.yandex.direct.web.core.model.retargeting.AbstractGoalWeb;
import ru.yandex.direct.web.core.model.retargeting.Condition;
import ru.yandex.direct.web.core.model.retargeting.RetargetingConditionWeb;

@ParametersAreNonnullByDefault
public class RetargetingPathConverters {
    public static final MappingPathNodeConverter RETARGETING_GOAL_PRESENTATION =
            MappingPathNodeConverter.builder(RetargetingPathConverters.class.getName())
                    .replace(Goal.ID.name(), AbstractGoalWeb.ID_FIELD_NAME)
                    .replace(Goal.TYPE.name(), AbstractGoalWeb.TYPE_FIELD_NAME)
                    .replace(Goal.TIME.name(), Goal.TIME.name())
                    .build();

    public static final MappingPathNodeConverter RETARGETING_CONDITION_PRESENTATION =
            MappingPathNodeConverter.builder(RetargetingPathConverters.class.getName())
                    .replace(RetargetingCondition.RULES.name(), RetargetingConditionWeb.CONDITIONS_FIELD_NAME)
                    .replace(RetargetingCondition.DESCRIPTION.name(), RetargetingConditionWeb.DESCRIPTION_FIELD_NAME)
                    .replace(RetargetingCondition.ID.name(), RetargetingConditionWeb.ID_FIELD_NAME)
                    .replace(RetargetingCondition.NAME.name(), RetargetingConditionWeb.NAME_FIELD_NAME)
                    .replace(RetargetingCondition.CLIENT_ID.name(), RetargetingConditionWeb.CLIENT_ID_FIELD_NAME)
                    .replace(RetargetingCondition.AVAILABLE.name(), RetargetingConditionWeb.IS_ACCESSIBLE_FIELD_NAME)
                    .build();

    public static final MappingPathNodeConverter RETARGETING_CONDITION_RULE_PRESENTATION =
            MappingPathNodeConverter.builder(RetargetingPathConverters.class.getName())
                    .replace(Rule.GOALS.name(), Condition.GOALS_FIELD_NAME)
                    .replace(Rule.TYPE.name(), Condition.TYPE_FIELD_NAME)
                    .replace(Rule.INTEREST_TYPE.name(), Condition.INTEREST_TYPE_FIELD_NAME)
                    .build();

    private RetargetingPathConverters() {
    }
}
