package ru.yandex.direct.intapi.entity.retargetinglists.controller;


import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

import ru.yandex.direct.common.net.NetworkName;
import ru.yandex.direct.core.entity.retargeting.service.RetargetingConditionService;
import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.intapi.entity.retargetinglists.model.GoalsForRetargetingResponse;
import ru.yandex.direct.web.core.model.WebErrorResponse;
import ru.yandex.direct.web.core.model.WebResponse;
import ru.yandex.direct.web.core.model.retargeting.MetrikaGoalWeb;
import ru.yandex.direct.web.core.model.retargeting.RetargetingConditionConverter;
import ru.yandex.direct.web.core.security.netacl.AllowNetworks;

import static ru.yandex.direct.utils.FunctionalUtils.mapList;

/**
 * Ручки для вызова из перлового бекенда.
 * Будут удалены, когда сохранение группы объявлений целиком будет портировано в java Web API.
 * До тех пор здесь будет некоторый копипаст моделек.
 */
@RestController
@RequestMapping("retargeting")
@Api(tags = "intapiRetargeting")
@AllowNetworks({NetworkName.DIRECT_PRODUCTION})
public class RetargetingController {
    private final RetargetingConditionService retargetingConditionService;

    @Autowired
    public RetargetingController(RetargetingConditionService retargetingConditionService) {
        this.retargetingConditionService = retargetingConditionService;
    }

    @ApiOperation(
            value = "getGoalsForRetargeting",
            httpMethod = "GET",
            nickname = "getGoalsForRetargeting"
    )
    @ApiResponses(
            {
                    @ApiResponse(code = 400, message = "Bad params", response = WebErrorResponse.class),
                    @ApiResponse(code = 200, message = "Ok", response = GoalsForRetargetingResponse.class)
            }
    )
    @RequestMapping(path = "/goals", method = RequestMethod.GET)
    @ResponseBody
    public WebResponse getGoalsForRetargeting(@RequestParam(value = "client_id") Long clientId) {
        return new GoalsForRetargetingResponse(mapList(
                retargetingConditionService.getMetrikaGoalsForRetargeting(
                        ClientId.fromLong(clientId)),
                goal -> (MetrikaGoalWeb) RetargetingConditionConverter.fromGoal(goal)
        ));
    }

}
