package ru.yandex.direct.intapi.entity.rmp;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;

import ru.yandex.direct.core.entity.client.model.Client;
import ru.yandex.direct.core.entity.client.service.ClientService;
import ru.yandex.direct.core.entity.user.model.User;
import ru.yandex.direct.core.entity.user.service.UserService;
import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.intapi.IntApiException;
import ru.yandex.direct.rbac.RbacService;

@Service
public class RmpControllerHelper {
    private final ClientService clientService;
    private final UserService userService;
    private final RbacService rbacService;

    @Autowired
    public RmpControllerHelper(
            ClientService clientService,
            UserService userService,
            RbacService rbacService
    ) {
        this.clientService = clientService;
        this.userService = userService;
        this.rbacService = rbacService;
    }

    public Client getClient(ClientId clientId) {
        Client client = clientService.getClient(clientId);
        if (client == null) {
            throw new IntApiException(HttpStatus.BAD_REQUEST, "Client not found");
        }
        return client;
    }

    public User getUser(ClientId clientId, Long uid) {
        User user = userService.getUser(uid);
        if (user == null) {
            throw new IntApiException(HttpStatus.BAD_REQUEST, "User not found");
        }
        if (!rbacService.isOwner(user.getUid(), rbacService.getChiefByClientId(clientId))) {
            throw new IntApiException(HttpStatus.BAD_REQUEST, "User has no rights to create campaign");
        }
        return user;
    }
}
