package ru.yandex.direct.intapi.entity.rmp.adgroups;

import java.util.List;
import java.util.Map;

import one.util.streamex.StreamEx;
import org.springframework.stereotype.Service;

import ru.yandex.direct.core.entity.adgroup.model.AdGroup;
import ru.yandex.direct.core.entity.aggregatedstatuses.adgroup.AggregatedStatusAdGroupData;
import ru.yandex.direct.core.entity.keyword.model.Keyword;
import ru.yandex.direct.core.entity.retargeting.Constants;

import static ru.yandex.direct.utils.CommonUtils.ifNotNull;

@Service
public class RmpAdGroupConverter {
    public List<RmpAdGroupResponse> toRmpAdGroupResponses(
            List<AdGroup> adGroups, Map<Long, AggregatedStatusAdGroupData> statusDataById) {
        return StreamEx.of(adGroups)
                .mapToEntry(adGroup -> adGroup, adGroup -> statusDataById.get(adGroup.getId()))
                .mapKeyValue((adGroup, statusData) -> new RmpAdGroupResponse()
                        .withId(adGroup.getId())
                        .withState(ifNotNull(statusData, AggregatedStatusAdGroupData::getStatusUnsafe))
                        .withStateReasons(ifNotNull(statusData, AggregatedStatusAdGroupData::getReasonsUnsafe)))
                .toList();
    }

    public List<Keyword> toKeywords(List<String> keywords) {
        if (keywords == null) {
            return null;
        }
        return StreamEx.of(keywords)
                .map(keyword -> new Keyword()
                        .withPhrase(keyword)
                        .withAutobudgetPriority(Constants.DEFAULT_AUTOBUDGET_PRIORITY))
                .toList();
    }
}
