package ru.yandex.direct.intapi.entity.rmp.banner;

import java.util.Map;

import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.direct.core.entity.uac.service.ModerationState;
import ru.yandex.direct.web.core.model.WebSuccessResponse;

public class RmpBannerResponse extends WebSuccessResponse {
    @JsonProperty("id")
    private Long id;

    @JsonProperty("ad_group_id")
    private Long adGroupId;

    @JsonProperty("campaign_id")
    private Long campaignId;

    @JsonProperty("title")
    private String title;

    @JsonProperty("text")
    private String text;

    @JsonProperty("tracking_url")
    private String trackingUrl;

    @JsonProperty("impression_url")
    private String impressionUrl;

    @JsonProperty("image_hash")
    private String imageHash;

    @JsonProperty("creative_id")
    private Long creativeId;

    @JsonProperty("status_show")
    private Boolean statusShow;

    @JsonProperty("status")
    private ModerationState status;

    @JsonProperty("image_status")
    private ModerationState imageStatus;

    @JsonProperty("creative_status")
    private ModerationState creativeStatus;

    @JsonProperty("state")
    private BannerState state;

    @JsonProperty("moderation_data")
    private ModerationData moderationData;

    @JsonProperty("flags")
    private Map<String, String> flags;

    public RmpBannerResponse withId(Long id) {
        this.id = id;
        return this;
    }

    public RmpBannerResponse withAdGroupId(Long adGroupId) {
        this.adGroupId = adGroupId;
        return this;
    }

    public RmpBannerResponse withCampaignId(Long campaignId) {
        this.campaignId = campaignId;
        return this;
    }

    public RmpBannerResponse withTitle(String title) {
        this.title = title;
        return this;
    }

    public RmpBannerResponse withText(String text) {
        this.text = text;
        return this;
    }

    public RmpBannerResponse withTrackingUrl(String trackingUrl) {
        this.trackingUrl = trackingUrl;
        return this;
    }

    public RmpBannerResponse withImpressionUrl(String impressionUrl) {
        this.impressionUrl = impressionUrl;
        return this;
    }

    public RmpBannerResponse withImageHash(String imageHash) {
        this.imageHash = imageHash;
        return this;
    }

    public RmpBannerResponse withCreativeId(Long creativeId) {
        this.creativeId = creativeId;
        return this;
    }

    public RmpBannerResponse withStatusShow(Boolean statusShow) {
        this.statusShow = statusShow;
        return this;
    }

    public RmpBannerResponse withStatus(ModerationState status) {
        this.status = status;
        return this;
    }

    public RmpBannerResponse withImageStatus(ModerationState imageStatus) {
        this.imageStatus = imageStatus;
        return this;
    }

    public RmpBannerResponse withCreativeStatus(ModerationState creativeStatus) {
        this.creativeStatus = creativeStatus;
        return this;
    }

    public RmpBannerResponse withState(BannerState state) {
        this.state = state;
        return this;
    }

    public RmpBannerResponse withModerationData(ModerationData moderationData) {
        this.moderationData = moderationData;
        return this;
    }

    public RmpBannerResponse withFlags(Map<String, String> flags) {
        this.flags = flags;
        return this;
    }
}
