package ru.yandex.direct.intapi.entity.rmp.banner;

import java.util.List;

import org.springframework.stereotype.Service;

import ru.yandex.direct.core.entity.adgroup.model.AdGroup;
import ru.yandex.direct.core.entity.adgroup.model.MobileContentAdGroup;
import ru.yandex.direct.core.entity.adgroup.service.AdGroupService;
import ru.yandex.direct.core.entity.campaign.model.BaseCampaign;
import ru.yandex.direct.core.entity.campaign.model.MobileContentCampaign;
import ru.yandex.direct.core.entity.campaign.repository.CampaignTypedRepository;
import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.dbutil.sharding.ShardHelper;

@Service
public class RmpBannerService {
    private final AdGroupService adGroupService;
    private final CampaignTypedRepository campaignTypedRepository;
    private final ShardHelper shardHelper;

    public RmpBannerService(
            AdGroupService adGroupService,
            CampaignTypedRepository campaignTypedRepository,
            ShardHelper shardHelper
    ) {
        this.adGroupService = adGroupService;
        this.campaignTypedRepository = campaignTypedRepository;
        this.shardHelper = shardHelper;
    }

    public MobileContentAdGroup getAdGroup(Long adGroupId) {
        AdGroup adGroup = adGroupService.getAdGroup(adGroupId);
        if (!(adGroup instanceof MobileContentAdGroup)) {
            return null;
        }
        return (MobileContentAdGroup) adGroup;
    }

    public MobileContentCampaign getCampaign(ClientId clientId, Long campaignId) {
        List<? extends BaseCampaign> campaigns = campaignTypedRepository.getTypedCampaigns(
                shardHelper.getShardByClientId(clientId),
                List.of(campaignId));
        if (campaigns.isEmpty() || !(campaigns.get(0) instanceof MobileContentCampaign)) {
            return null;
        }
        return (MobileContentCampaign) campaigns.get(0);
    }
}
