package ru.yandex.direct.intapi.entity.rmp.banner;

import java.util.List;
import java.util.Set;

import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;

import ru.yandex.direct.core.entity.adgroup.model.MobileContentAdGroup;
import ru.yandex.direct.core.entity.banner.model.BannerWithSystemFields;
import ru.yandex.direct.core.entity.campaign.model.MobileContentCampaign;
import ru.yandex.direct.core.entity.uac.service.UacBannerService;
import ru.yandex.direct.core.entity.user.model.User;
import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.intapi.IntApiException;

@Service
public class RmpBannerValidationService {
    private final UacBannerService uacBannerService;
    private final RmpBannerService rmpBannerService;

    public RmpBannerValidationService(
            UacBannerService uacBannerService,
            RmpBannerService rmpBannerService
    ) {
        this.uacBannerService = uacBannerService;
        this.rmpBannerService = rmpBannerService;
    }

    public void validateRequest(ClientId clientId, AddRmpBannerRequest request) {
        MobileContentCampaign campaign = rmpBannerService.getCampaign(clientId, request.getCampaignId());
        if (campaign == null) {
            throw new IntApiException(HttpStatus.BAD_REQUEST, "Campaign not found");
        }
        if (clientId.asLong() != campaign.getClientId()) {
            throw new IntApiException(HttpStatus.BAD_REQUEST, "Foreign campaign");
        }
        if (request.getAdGroupId() == null) {
            return;
        }
        MobileContentAdGroup group = rmpBannerService.getAdGroup(request.getAdGroupId());
        if (!campaign.getId().equals(group.getCampaignId())) {
            throw new IntApiException(HttpStatus.BAD_REQUEST, "Ad group does not correspond to campaign");
        }
    }

    public void validateAdGroupId(Long adGroupId) {
        MobileContentAdGroup group = rmpBannerService.getAdGroup(adGroupId);
        if (group == null) {
            throw new IntApiException(HttpStatus.BAD_REQUEST, "Invalid adGroupId");
        }
    }

    public void validateBannerId(User operator, ClientId clientId, Long bannerId) {
        List<BannerWithSystemFields> banners =
                uacBannerService.getMobileAppBanners(operator.getUid(), clientId, Set.of(bannerId));
        if (banners.isEmpty()) {
            throw new IntApiException(HttpStatus.BAD_REQUEST, "Invalid banner id");
        }
        BannerWithSystemFields banner = banners.get(0);
        MobileContentCampaign campaign = rmpBannerService.getCampaign(clientId, banner.getCampaignId());
        if (campaign == null) {
            throw new IntApiException(HttpStatus.BAD_REQUEST, "Invalid campaign");
        }
        if (campaign.getClientId() != clientId.asLong()) {
            throw new IntApiException(HttpStatus.BAD_REQUEST, "Foreign campaign");
        }
    }
}
