package ru.yandex.direct.intapi.entity.rmp.campaigns;

import java.util.List;

import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.direct.core.entity.campaign.model.CampaignSource;
import ru.yandex.direct.core.entity.uac.model.UacStrategyPlatform;

public class AddRmpCampaignRequest {

    @JsonProperty(value = "name", required = true)
    private String name;

    @JsonProperty(value = "app_info", required = true)
    private AddAppInfoRequest appInfo;

    @JsonProperty(value = "regions", required = false)
    private List<Long> regions;

    @JsonProperty(value = "target", required = true)
    private Target target;

    @JsonProperty(value = "cost", required = true)
    private Long cost;

    @JsonProperty(value = "week_cost", required = true)
    private Long weekCost;

    @JsonProperty(value = "pay_for_conversion", required = false)
    private Boolean payForConversion;

    @JsonProperty(value = "is_skad_network_enabled", required = false)
    private Boolean isSkadNetworkEnabled;

    @JsonProperty(value = "adult_content_enabled", required = false)
    private Boolean adultContentEnabled;

    @JsonProperty(value = "strategy_platform", required = false)
    private UacStrategyPlatform strategyPlatform;

    @JsonProperty(value = "source")
    @Nullable
    private CampaignSource source = null;

    public String getName() {
        return name;
    }

    public AddAppInfoRequest getAppInfo() {
        return appInfo;
    }

    public List<Long> getRegions() {
        return regions;
    }

    public Target getTarget() {
        return target;
    }

    public Long getCost() {
        return cost;
    }

    public Long getWeekCost() {
        return weekCost;
    }

    public Boolean getPayForConversion() {
        return payForConversion;
    }

    public Boolean getIsSkadNetworkEnabled() {
        return isSkadNetworkEnabled;
    }

    public Boolean getAdultContentEnabled() {
        return adultContentEnabled;
    }

    public CampaignSource getSource() {
        return source;
    }

    public UacStrategyPlatform getStrategyPlatform() {
        return strategyPlatform;
    }

    public void setStrategyPlatform(UacStrategyPlatform strategyPlatform) {
        this.strategyPlatform = strategyPlatform;
    }
}
