package ru.yandex.direct.intapi.entity.rmp.campaigns;

import java.math.BigDecimal;
import java.util.List;
import java.util.Set;

import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.direct.core.entity.aggregatedstatuses.GdSelfStatusReason;
import ru.yandex.direct.core.entity.moderationdiag.model.ModerationDiagData;
import ru.yandex.direct.core.entity.uac.service.CampaignState;
import ru.yandex.direct.core.entity.uac.service.ModerationState;
import ru.yandex.direct.web.core.model.WebSuccessResponse;

public class RmpCampaignResponse extends WebSuccessResponse {

    @JsonProperty("id")
    private Long id;

    @JsonProperty("title")
    private String title;

    @JsonProperty("app_title")
    private String appTitle;

    @JsonProperty("store_url")
    private String storeUrl;

    @JsonProperty("icon_url")
    private String iconUrl;

    @JsonProperty("rating")
    private BigDecimal rating;

    @JsonProperty("rating_votes")
    private Long ratingVotes;

    @JsonProperty("age_limit")
    private Long ageLimit;

    @JsonProperty("min_os")
    private String minOs;

    @JsonProperty("regions")
    private List<Integer> regions;

    @JsonProperty("target")
    private Target target;

    @JsonProperty("cost")
    private Long cost;

    @JsonProperty("week_limit")
    private Long weekLimit;

    @JsonProperty("icon_state")
    private ModerationState iconState;

    @JsonProperty("status_show")
    private Boolean statusShow;

    @JsonProperty("campaign_status")
    private ModerationState campaignStatus;

    @JsonProperty("campaign_state")
    private CampaignState campaignState;

    @JsonProperty("campaign_state_reasons")
    private List<GdSelfStatusReason> campaignStateReasons;

    @JsonProperty("moderation_diags")
    private List<ModerationDiagData> moderationDiags;

    public RmpCampaignResponse withId(Long id) {
        this.id = id;
        return this;
    }

    public RmpCampaignResponse withTitle(String title) {
        this.title = title;
        return this;
    }

    public RmpCampaignResponse withAppTitle(String appTitle) {
        this.appTitle = appTitle;
        return this;
    }

    public RmpCampaignResponse withStoreUrl(String storeUrl) {
        this.storeUrl = storeUrl;
        return this;
    }

    public RmpCampaignResponse withIconUrl(String iconUrl) {
        this.iconUrl = iconUrl;
        return this;
    }

    public RmpCampaignResponse withRating(BigDecimal rating) {
        this.rating = rating;
        return this;
    }

    public RmpCampaignResponse withRatingVotes(Long ratingVotes) {
        this.ratingVotes = ratingVotes;
        return this;
    }

    public RmpCampaignResponse withAgeLimit(Long ageLimit) {
        this.ageLimit = ageLimit;
        return this;
    }

    public RmpCampaignResponse withMinOs(String minOs) {
        this.minOs = minOs;
        return this;
    }

    public RmpCampaignResponse withRegions(Set<Integer> regions) {
        this.regions = List.copyOf(regions);
        return this;
    }

    public RmpCampaignResponse withTarget(Target target) {
        this.target = target;
        return this;
    }

    public RmpCampaignResponse withCost(Long cost) {
        this.cost = cost;
        return this;
    }

    public RmpCampaignResponse withWeekLimit(Long weekLimit) {
        this.weekLimit = weekLimit;
        return this;
    }

    public RmpCampaignResponse withIconState(ModerationState iconState) {
        this.iconState = iconState;
        return this;
    }

    public RmpCampaignResponse withStatusShow(Boolean statusShow) {
        this.statusShow = statusShow;
        return this;
    }

    public RmpCampaignResponse withCampaignStatus(ModerationState campaignStatus) {
        this.campaignStatus = campaignStatus;
        return this;
    }

    public RmpCampaignResponse withCampaignState(CampaignState campaignState) {
        this.campaignState = campaignState;
        return this;
    }

    public RmpCampaignResponse withCampaignStateReasons(List<GdSelfStatusReason> campaignStateReasons) {
        this.campaignStateReasons = campaignStateReasons;
        return this;
    }

    public RmpCampaignResponse withModerationDiags(List<ModerationDiagData> moderationDiags) {
        this.moderationDiags = moderationDiags;
        return this;
    }
}
