package ru.yandex.direct.intapi.entity.rmp.campaigns;

import java.util.Map;

import com.google.common.collect.ImmutableMap;


public enum Target {
    CPC(0L),
    INSTALL(4L),
    GOAL(38402972L),
    LAUNCH(38403008L),
    PAYMENT(38403053L),
    BASKET(38403071L),
    WISH_LIST(38403080L),
    REGISTER(38403095L),
    TRAIN(38403104L),
    ORDER(38403131L),
    BUY(38403173L),
    RATING(38403191L),
    SEARCH(38403197L),
    CREDITS(38403206L),
    LEVELUP(38403215L),
    WATCH(38403230L),
    TIMESPENT(38403338L),
    SHARE(38403494L),
    USER_1(38403530L),
    USER_2(38403545L),
    USER_3(38403581L);

    private final Long goalId;

    private static final Map<Long, Target> LOOKUP;

    static {
        ImmutableMap.Builder<Long, Target> builder = ImmutableMap.builder();
        for (Target target : values()) {
            builder.put(target.getGoalId(), target);
        }
        LOOKUP = builder.build();
    }


    Target(Long goalId) {
        this.goalId = goalId;
    }

    public Long getGoalId() {
        return goalId;
    }

    public static Target getByGoalId(Long goalId) {
        return LOOKUP.get(goalId);
    }
}
