package ru.yandex.direct.intapi.entity.rmp.content;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.stereotype.Service;

import ru.yandex.direct.core.entity.image.container.UploadedBannerImageInformation;
import ru.yandex.direct.core.entity.image.model.BannerImageSource;

@Service
@ParametersAreNonnullByDefault
public class RmpContentConverter {
    public RmpContentResponse toRmpContentResponse(UploadedBannerImageInformation imageInformation) {
        return new RmpContentResponse()
                .withHash(imageInformation.getImageHash())
                .withMdsGroupId(imageInformation.getMdsGroupId())
                .withMdsNamespace(imageInformation.getNamespace())
                .withName(imageInformation.getName())
                .withWidth(imageInformation.getWidth())
                .withHeight(imageInformation.getHeight())
                .withImageType(imageInformation.getImageType())
                .withMdsMeta(imageInformation.getMdsMeta());
    }

    public BannerImageSource toBannerImageSource(@Nullable Boolean isUac) {
        return Boolean.TRUE.equals(isUac) ? BannerImageSource.UAC : BannerImageSource.DIRECT;
    }
}
