package ru.yandex.direct.intapi.entity.rmp.content;

import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.direct.core.entity.banner.model.ImageType;
import ru.yandex.direct.core.entity.image.model.BannerImageFormatNamespace;
import ru.yandex.direct.core.entity.image.model.ImageMdsMeta;
import ru.yandex.direct.web.core.model.WebSuccessResponse;

public class RmpContentResponse extends WebSuccessResponse {
    @JsonProperty("hash")
    private String hash;

    @JsonProperty("mds_group_id")
    private Integer mdsGroupId;

    @JsonProperty("mds_namespace")
    private BannerImageFormatNamespace mdsNamespace;

    @JsonProperty("name")
    private String name;

    @JsonProperty("width")
    private Integer width;

    @JsonProperty("height")
    private Integer height;

    @JsonProperty("image_type")
    private ImageType imageType;

    @JsonProperty("mds_meta")
    private ImageMdsMeta mdsMeta;

    public RmpContentResponse withHash(String hash) {
        this.hash = hash;
        return this;
    }

    public RmpContentResponse withMdsGroupId(Integer mdsGroupId) {
        this.mdsGroupId = mdsGroupId;
        return this;
    }

    public RmpContentResponse withMdsNamespace(BannerImageFormatNamespace mdsNamespace) {
        this.mdsNamespace = mdsNamespace;
        return this;
    }

    public RmpContentResponse withName(String name) {
        this.name = name;
        return this;
    }

    public RmpContentResponse withWidth(Integer width) {
        this.width = width;
        return this;
    }

    public RmpContentResponse withHeight(Integer height) {
        this.height = height;
        return this;
    }

    public RmpContentResponse withImageType(ImageType imageType) {
        this.imageType = imageType;
        return this;
    }

    public RmpContentResponse withMdsMeta(ImageMdsMeta mdsMeta) {
        this.mdsMeta = mdsMeta;
        return this;
    }
}
