package ru.yandex.direct.intapi.entity.sharding;

import java.util.List;

import javax.ws.rs.POST;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import ru.yandex.direct.intapi.ErrorResponse;
import ru.yandex.direct.intapi.entity.sharding.model.GenerateObjectIdsRequest;
import ru.yandex.direct.intapi.entity.sharding.model.GenerateObjectIdsResponse;
import ru.yandex.direct.intapi.entity.sharding.service.IntapiShardingService;
import ru.yandex.direct.tvm.AllowServices;

import static ru.yandex.direct.tvm.TvmService.DIRECT_API_PROD;
import static ru.yandex.direct.tvm.TvmService.DIRECT_API_SANDBOX;
import static ru.yandex.direct.tvm.TvmService.DIRECT_API_SANDBOX_TEST;
import static ru.yandex.direct.tvm.TvmService.DIRECT_API_TEST;
import static ru.yandex.direct.tvm.TvmService.DIRECT_DEVELOPER;
import static ru.yandex.direct.tvm.TvmService.DIRECT_INTAPI_PROD;
import static ru.yandex.direct.tvm.TvmService.DIRECT_INTAPI_SANDBOX;
import static ru.yandex.direct.tvm.TvmService.DIRECT_INTAPI_SANDBOX_TEST;
import static ru.yandex.direct.tvm.TvmService.DIRECT_INTAPI_TEST;
import static ru.yandex.direct.tvm.TvmService.DIRECT_SCRIPTS_PROD;
import static ru.yandex.direct.tvm.TvmService.DIRECT_SCRIPTS_SANDBOX;
import static ru.yandex.direct.tvm.TvmService.DIRECT_SCRIPTS_SANDBOX_TEST;
import static ru.yandex.direct.tvm.TvmService.DIRECT_SCRIPTS_TEST;
import static ru.yandex.direct.tvm.TvmService.DIRECT_WEB_PROD;
import static ru.yandex.direct.tvm.TvmService.DIRECT_WEB_TEST;

@RestController
@RequestMapping(
        name = "sharding",
        path = "/sharding",
        produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
@Api(value = "API для операций с шардами и справочными данными шардированных объектов",
        tags = "intapiSharding")
@AllowServices(
        production = {DIRECT_WEB_PROD, DIRECT_SCRIPTS_PROD, DIRECT_INTAPI_PROD, DIRECT_API_PROD},
        testing = {DIRECT_WEB_TEST, DIRECT_SCRIPTS_TEST, DIRECT_INTAPI_TEST, DIRECT_API_TEST, DIRECT_DEVELOPER},
        sandbox = {DIRECT_INTAPI_SANDBOX, DIRECT_API_SANDBOX, DIRECT_SCRIPTS_SANDBOX},
        sandboxTesting = {DIRECT_INTAPI_SANDBOX_TEST, DIRECT_API_SANDBOX_TEST, DIRECT_SCRIPTS_SANDBOX_TEST,
                DIRECT_DEVELOPER}
)
public class ShardingController {
    private IntapiShardingService intapiShardingService;

    @Autowired
    public ShardingController(IntapiShardingService intapiShardingService) {
        this.intapiShardingService = intapiShardingService;
    }

    @POST
    @ApiOperation(
            value = "генерация идентификаторов указанных объектов",
            nickname = "generateObjectIds",
            httpMethod = "POST"
    )
    @ApiResponses({
            @ApiResponse(code = 200, message = "список сгенерированных идентификаторов",
                    response = GenerateObjectIdsResponse.class),
            @ApiResponse(code = 400, message = "ошибка запроса", response = ErrorResponse.class)})
    @RequestMapping(path = "/generateObjectIds",
            method = RequestMethod.POST
    )
    public GenerateObjectIdsResponse generateObjectIds(
            @ApiParam(value = "запрос идентификаторов", required = true)
            @RequestBody GenerateObjectIdsRequest request) {

        List<Long> ids = intapiShardingService.generateObjectIds(
                request.getType(),
                request.getCount(),
                request.getClientId());

        return new GenerateObjectIdsResponse().withIds(ids);
    }
}
