package ru.yandex.direct.intapi.entity.sharding.model;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.checkerframework.checker.nullness.qual.NonNull;

import ru.yandex.direct.dbutil.model.ClientId;

public class GenerateObjectIdsRequest {
    @JsonProperty("type")
    @Nonnull
    private final String type;

    @JsonProperty("count")
    @Nonnull
    private final Integer count;

    @JsonProperty("client_id")
    @Nullable
    private final ClientId clientId;


    @JsonCreator
    public GenerateObjectIdsRequest(
            @NonNull @JsonProperty("type") String type,
            @NonNull @JsonProperty("count") Integer count,
            @Nullable @JsonProperty("client_id") ClientId clientId) {
        this.type = type;
        this.count = count;
        this.clientId = clientId;
    }

    @Nonnull
    public String getType() {
        return type;
    }

    @Nonnull
    public Integer getCount() {
        return count;
    }

    @Nullable
    public ClientId getClientId() {
        return clientId;
    }
}
