package ru.yandex.direct.intapi.entity.sharding.service;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;

import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.dbutil.sharding.AutoIncrementKey;
import ru.yandex.direct.dbutil.sharding.ShardHelper;
import ru.yandex.direct.dbutil.sharding.ShardKey;
import ru.yandex.direct.intapi.ErrorResponse;
import ru.yandex.direct.intapi.IntApiException;

import static java.util.Objects.nonNull;

@Service
public class IntapiShardingService {

    private final ShardHelper shardHelper;

    @Autowired
    public IntapiShardingService(ShardHelper shardHelper) {
        this.shardHelper = shardHelper;
    }

    /**
     * Генерирует идентификаторы заданных объектов
     */
    public List<Long> generateObjectIds(String type, Integer count, ClientId clientId) {

        try {
            ShardKey shardKey = Enum.valueOf(ShardKey.class, type.toUpperCase());
            if (nonNull(clientId)) {
                return shardHelper.generateIdsByShardKey(shardKey, clientId.asLong(), count);
            }
            throw new IntApiException(HttpStatus.BAD_REQUEST,
                    new ErrorResponse(ErrorResponse.ErrorCode.INTERNAL_ERROR,
                            "client_id required when " + type + " given"));
        } catch (IllegalArgumentException es) {
            try {
                AutoIncrementKey aiKey = Enum.valueOf(AutoIncrementKey.class, type.toUpperCase());
                return shardHelper.generateIdsByAutoIncrementKey(aiKey, count);
            } catch (IllegalArgumentException ea) {
                throw new IntApiException(HttpStatus.BAD_REQUEST,
                        new ErrorResponse(ErrorResponse.ErrorCode.BAD_PARAM, "unknown object type " + type));
            }
        }
    }
}
