package ru.yandex.direct.intapi.entity.showconditions;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.i18n.I18NBundle;
import ru.yandex.direct.i18n.Translatable;
import ru.yandex.direct.i18n.bundle.TranslationBundle;
import ru.yandex.direct.i18n.bundle.TranslationStub;


/**
 * Здесь объявляются переводы для статусов баннеров.
 */
@ParametersAreNonnullByDefault
public interface BannerStatusTranslations extends TranslationBundle {

    BannerStatusTranslations
            INSTANCE = I18NBundle.implement(BannerStatusTranslations.class);

    @TranslationStub("Принято к показам.")
    Translatable getToShow();

    @TranslationStub("Идут показы.")
    Translatable showsAreGoing();

    @TranslationStub("Идет активизация.")
    Translatable activating();

    @TranslationStub("Объявление принято.")
    Translatable adAccepted();

    @TranslationStub("Контактная информация ожидает модерации.")
    Translatable contactInfoWaitModeration();

    @TranslationStub("Быстрые ссылки ожидают модерации.")
    Translatable sitelinksWaitModeration();

    @TranslationStub("Изображение ожидает модерации.")
    Translatable imageWaitModeration();

    @TranslationStub("Отображаемая ссылка ожидает модерации.")
    Translatable displayHrefWaitModeration();

    @TranslationStub("Видеодополнение ожидает модерации.")
    Translatable videoAdditionsWaitModeration();

    @TranslationStub("Турбо-страница ожидает модерации.")
    Translatable turboLandingWaitModeration();

    @TranslationStub("Ожидает модерации.")
    Translatable waitModeration();

    @TranslationStub("Черновик.")
    Translatable draft();

    @TranslationStub("Отклонено модератором.")
    Translatable declineModeration();

    @TranslationStub("Контактная информация отклонена.")
    Translatable contactInfoDeclinedModeration();

    @TranslationStub("Часть фраз отклонена.")
    Translatable keywordsDeclinedModeration();

    @TranslationStub("Быстрые ссылки отклонены.")
    Translatable sitelinksDeclinedModeration();

    @TranslationStub("Изображение отклонено.")
    Translatable imageDeclinedModeration();

    @TranslationStub("Уточнения отклонены.")
    Translatable calloutDeclinedModeration();

    @TranslationStub("Отображаемая ссылка отклонена.")
    Translatable displayHrefDeclinedModeration();

    @TranslationStub("Видеодополнение отклонено.")
    Translatable videoAdditionsDeclinedModeration();

    @TranslationStub("Турбо-страница отклонена.")
    Translatable turboLandingDeclinedModeration();

    @TranslationStub("Объявления не созданы.")
    Translatable blNothingGenerated(); // нет теста

    @TranslationStub("Идет обработка.")
    Translatable blProcession(); // нет теста

    @TranslationStub("контактная информация")
    Translatable contactInfoMultiplyDeclined();

    @TranslationStub("часть фраз")
    Translatable keywordsMultiplyDeclined();

    @TranslationStub("быстрые ссылки")
    Translatable sitelinksMultiplyDeclined();

    @TranslationStub("изображение")
    Translatable imageMultiplyDeclined();

    @TranslationStub("уточнения")
    Translatable calloutMultiplyDeclined();

    @TranslationStub("отображаемая ссылка")
    Translatable displayHrefMultiplyDeclined();

    @TranslationStub("видеодополнение")
    Translatable videoAdditionsMultiplyDeclined();

    @TranslationStub("Турбо-страница")
    Translatable turboLandingMultiplyDeclined();

    @TranslationStub("Отклонены: ")
    Translatable multiplyDeclined();

}
