package ru.yandex.direct.intapi.entity.showconditions.controller;

import javax.ws.rs.POST;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

import ru.yandex.direct.common.net.NetworkName;
import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.intapi.ErrorResponse;
import ru.yandex.direct.intapi.entity.showconditions.model.request.ShowConditionsRequest;
import ru.yandex.direct.intapi.entity.showconditions.model.response.ShowConditionsResponse;
import ru.yandex.direct.intapi.entity.showconditions.service.ShowConditionsService;
import ru.yandex.direct.intapi.logging.ClientIdParam;
import ru.yandex.direct.intapi.logging.OperatorUid;
import ru.yandex.direct.web.core.model.WebResponse;
import ru.yandex.direct.web.core.security.netacl.AllowNetworks;

/**
 * Ручки для вызова из перлового бекенда.
 */
@RestController
@RequestMapping("showconditions")
@Api(tags = "intapiShowConditions")
@AllowNetworks(NetworkName.DIRECT_PRODUCTION)
public class ShowConditionsController {

    private final ShowConditionsService showConditionsService;

    @Autowired
    public ShowConditionsController(ShowConditionsService showConditionsService) {
        this.showConditionsService = showConditionsService;
    }

    @POST
    @ApiOperation(
            value = "update",
            httpMethod = "POST",
            nickname = "update"
    )
    @ApiResponses(
            {
                    @ApiResponse(code = 400, message = "Bad params", response = ErrorResponse.class),
                    @ApiResponse(code = 200, message = "Ok", response = ShowConditionsResponse.class)
            }
    )
    @RequestMapping(path = "/update",
            method = RequestMethod.POST,
            consumes = MediaType.APPLICATION_JSON_UTF8_VALUE,
            produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    @ResponseBody
    public WebResponse update(
            @RequestBody ShowConditionsRequest request,
            @RequestParam(value = "operator_uid") @OperatorUid Long operatorUid,
            @RequestParam(value = "client_id") @ClientIdParam Long clientId) {
        return showConditionsService.doOperations(operatorUid, ClientId.fromLong(clientId), request);
    }
}
