package ru.yandex.direct.intapi.entity.showconditions.model.request;

import java.math.BigDecimal;

import com.fasterxml.jackson.annotation.JsonProperty;

public class KeywordAddItem {
    @JsonProperty("phrase")
    private String phrase;

    @JsonProperty("price")
    private BigDecimal price;

    @JsonProperty("price_context")
    private BigDecimal priceContext;

    @JsonProperty("autobudgetPriority")
    private Integer autobudgetPriority;

    @JsonProperty("report_row_hash")
    private String reportRowHash;

    public String getPhrase() {
        return phrase;
    }

    public KeywordAddItem withPhrase(String phrase) {
        this.phrase = phrase;
        return this;
    }

    public BigDecimal getPrice() {
        return price;
    }

    public KeywordAddItem withPrice(BigDecimal price) {
        this.price = price;
        return this;
    }

    public BigDecimal getPriceContext() {
        return priceContext;
    }

    public KeywordAddItem withPriceContext(BigDecimal priceContext) {
        this.priceContext = priceContext;
        return this;
    }

    public Integer getAutobudgetPriority() {
        return autobudgetPriority;
    }

    public KeywordAddItem withAutobudgetPriority(Integer autobudgetPriority) {
        this.autobudgetPriority = autobudgetPriority;
        return this;
    }

    public String getReportRowHash() {
        return reportRowHash;
    }

    public KeywordAddItem withReportRowHash(String reportRowHash) {
        this.reportRowHash = reportRowHash;
        return this;
    }
}
