package ru.yandex.direct.intapi.entity.showconditions.model.request;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.fasterxml.jackson.annotation.JsonProperty;

public class KeywordModificationContainer {

    private List<KeywordAddItem> added = new ArrayList<>();

    @JsonProperty("edited")
    private Map<Long, KeywordUpdateItem> updated = new HashMap<>();

    private List<Long> deleted = new ArrayList<>();

    @JsonProperty("main_bid")
    private Long mainBid;

    public List<KeywordAddItem> getAdded() {
        return added;
    }

    public KeywordModificationContainer withAdded(List<KeywordAddItem> added) {
        this.added = added;
        return this;
    }

    public Map<Long, KeywordUpdateItem> getUpdated() {
        return updated;
    }

    public KeywordModificationContainer withUpdated(Map<Long, KeywordUpdateItem> updated) {
        this.updated = updated;
        return this;
    }

    public List<Long> getDeleted() {
        return deleted;
    }

    public KeywordModificationContainer withDeleted(List<Long> deleted) {
        this.deleted = deleted;
        return this;
    }

    public Long getMainBid() {
        return mainBid;
    }
}
