package ru.yandex.direct.intapi.entity.showconditions.model.request;

import java.math.BigDecimal;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;

public class KeywordUpdateItem {
    @JsonProperty("phrase")
    private String phrase;

    @JsonProperty("price")
    private BigDecimal price;

    @JsonProperty("price_context")
    private BigDecimal priceContext;

    @JsonProperty("autobudgetPriority")
    private Integer autobudgetPriority;

    @JsonProperty("is_suspended")
    @JsonDeserialize
    private Integer isSuspended;

    public String getPhrase() {
        return phrase;
    }

    public KeywordUpdateItem withPhrase(String phrase) {
        this.phrase = phrase;
        return this;
    }

    public BigDecimal getPrice() {
        return price;
    }

    public KeywordUpdateItem withPrice(BigDecimal price) {
        this.price = price;
        return this;
    }

    public BigDecimal getPriceContext() {
        return priceContext;
    }

    public KeywordUpdateItem withPriceContext(BigDecimal priceContext) {
        this.priceContext = priceContext;
        return this;
    }

    public Integer getAutobudgetPriority() {
        return autobudgetPriority;
    }

    public KeywordUpdateItem withAutobudgetPriority(Integer autobudgetPriority) {
        this.autobudgetPriority = autobudgetPriority;
        return this;
    }

    public Integer getSuspended() {
        return isSuspended;
    }

    public KeywordUpdateItem withSuspended(Integer suspended) {
        isSuspended = suspended;
        return this;
    }
}
