package ru.yandex.direct.intapi.entity.showconditions.model.request;

import java.math.BigDecimal;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonProperty;

import static com.fasterxml.jackson.annotation.JsonAutoDetect.Visibility.ANY;
import static com.fasterxml.jackson.annotation.JsonAutoDetect.Visibility.NONE;

@JsonAutoDetect(fieldVisibility = ANY, getterVisibility = NONE, isGetterVisibility = NONE, setterVisibility = NONE)
public abstract class RelevanceMatchItemBase<T extends RelevanceMatchItemBase<T>> {

    @JsonProperty("price")
    private BigDecimal price;

    @JsonProperty("autobudgetPriority")
    private Integer autobudgetPriority;

    @JsonProperty("price_context")
    private BigDecimal priceContext;

    public BigDecimal getPrice() {
        return price;
    }

    public BigDecimal getPriceContext() {
        return priceContext;
    }


    public Integer getAutobudgetPriority() {
        return autobudgetPriority;
    }

    public T self() {
        return (T) this;
    }

    public T withPrice(BigDecimal price) {
        this.price = price;

        return self();
    }

    public T withPriceContext(BigDecimal price) {
        this.priceContext = price;
        return self();
    }

    public T withAutobudgetPriority(Integer autobudgetPriority) {
        this.autobudgetPriority = autobudgetPriority;
        return self();
    }
}

