package ru.yandex.direct.intapi.entity.showconditions.model.request;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.fasterxml.jackson.annotation.JsonProperty;

public class RelevanceMatchModificationContainer {
    private List<RelevanceMatchAddItem> added = new ArrayList<>();
    private Map<Long, RelevanceMatchItem> edited = new HashMap<>();
    private List<Long> deleted = new ArrayList<>();

    @JsonProperty("main_bid")
    private Long mainBid;

    public List<RelevanceMatchAddItem> getAdded() {
        return added;
    }

    public RelevanceMatchModificationContainer withAdded(List<RelevanceMatchAddItem> added) {
        this.added = added;
        return this;
    }


    public Map<Long, RelevanceMatchItem> getEdited() {
        return edited;
    }

    public RelevanceMatchModificationContainer withEdited(Map<Long, RelevanceMatchItem> edited) {
        this.edited = edited;
        return this;
    }

    public List<Long> getDeleted() {
        return deleted;
    }

    public RelevanceMatchModificationContainer withDeleted(List<Long> deleted) {
        this.deleted = deleted;
        return this;
    }

    public Long getMainBid() {
        return mainBid;
    }
}

