package ru.yandex.direct.intapi.entity.showconditions.model.request;

import java.math.BigDecimal;

import com.fasterxml.jackson.annotation.JsonProperty;

public class RetargetingItem {
    public static final String PRICE_CONTEXT_FIELD_NAME = "price_context";
    public static final String AUTOBUDGET_PRIORITY_FIELD_NAME = "autobudgetPriority";
    public static final String IS_SUSPENDED_FIELD_NAME = "is_suspended";

    @JsonProperty(PRICE_CONTEXT_FIELD_NAME)
    private BigDecimal priceContext;

    @JsonProperty(AUTOBUDGET_PRIORITY_FIELD_NAME)
    private Integer autobudgetPriority;

    @JsonProperty(IS_SUSPENDED_FIELD_NAME)
    private Integer isSuspended;

    public BigDecimal getPriceContext() {
        return priceContext;
    }

    public Integer getAutobudgetPriority() {
        return autobudgetPriority;
    }

    public Integer getSuspended() {
        return isSuspended;
    }

    public RetargetingItem withPriceContext(final BigDecimal priceContext) {
        this.priceContext = priceContext;
        return this;
    }

    public RetargetingItem withAutobudgetPriority(final Integer autobudgetPriority) {
        this.autobudgetPriority = autobudgetPriority;
        return this;
    }

    public RetargetingItem withIsSuspended(final Integer isSuspended) {
        this.isSuspended = isSuspended;
        return this;
    }

}
