package ru.yandex.direct.intapi.entity.showconditions.model.response;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.direct.core.entity.banner.model.BannerStatusModerate;
import ru.yandex.misc.lang.StringUtils;

@JsonInclude(JsonInclude.Include.NON_NULL)
public class BannerItemResponse {

    @JsonProperty("BannerID")
    private Long bsBannerID;

    @JsonProperty("statusModerate")
    private String statusModerate;

    @JsonProperty("statusShow")
    private String statusShow;

    @JsonProperty("statusActive")
    private String statusActive;

    @JsonProperty("status")
    private String textStatus;

    private Long bannerId;
    private Long adgroupId;

    public BannerItemResponse(Long bannerId, Long adgroupId) {
        this.bannerId = bannerId;
        this.adgroupId = adgroupId;
    }

    private String convertToYesNo(boolean status) {
        return status ? "Yes" : "No";
    }

    public BannerItemResponse withBannerID(Long bsBannerID) {
        this.bsBannerID = bsBannerID;
        return this;
    }

    public BannerItemResponse withStatusModerate(BannerStatusModerate statusModerate) {
        this.statusModerate = StringUtils.capitalize(statusModerate.name().toLowerCase());
        return this;
    }

    public BannerItemResponse withStatusShow(boolean statusShow) {
        this.statusShow = convertToYesNo(statusShow);
        return this;
    }

    public BannerItemResponse withStatusActive(boolean statusActive) {
        this.statusActive = convertToYesNo(statusActive);
        return this;
    }

    public BannerItemResponse withTextStatus(String textStatus) {
        this.textStatus = textStatus;
        return this;
    }

    public String getTextStatus() {
        return textStatus;
    }

    public Long getBannerId() {
        return bannerId;
    }

    public Long getAdgroupId() {
        return adgroupId;
    }

    public void removeBannerAndAdgroupIds() {
        bannerId = null;
        adgroupId = null;
    }
}
