package ru.yandex.direct.intapi.entity.showconditions.model.response;

import java.util.List;
import java.util.Map;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

@JsonInclude(JsonInclude.Include.NON_NULL)
public class KeywordItemResponse {
    // todo DIRECT-81272 изменить типы данных для некоторых полей - некоторые числа передаются как строки.

    @JsonProperty("id")
    private Long id;

    @JsonProperty("phrase_unglued_suffix")
    private String phraseUngluedSuffix;

    @JsonProperty("phrase")
    private String phrase;

    @JsonProperty("fixation")
    private List<List<String>> fixations;

    @JsonProperty("dublicate") //именно с опечаткой
    private Integer duplicate;

    @JsonProperty("is_suspended")
    private Integer isSuspended;

    @JsonProperty("price")
    private String price;

    @JsonProperty("price_context")
    private String priceContext;

    @JsonProperty("Ctr")
    private String ctr;

    @JsonProperty("Shows")
    private Long shows;

    @JsonProperty("clicks")
    private Long clicks;

    @JsonProperty("PhraseID")
    private String phraseId;

    @JsonProperty("norm_phrase")
    private String normPhrase;

    @JsonProperty("numword")
    private Integer wordsCount;

    @JsonProperty("traffic_volume")
    private Map<Integer, TrafficVolumeItem> trafficVolume;

    @JsonProperty("price_for_coverage")
    private Map<Integer, String> priceForCoverage;

    public Long getId() {
        return id;
    }

    public KeywordItemResponse withId(Long id) {
        this.id = id;
        return this;
    }

    public String getPhraseUngluedSuffix() {
        return phraseUngluedSuffix;
    }

    public KeywordItemResponse withPhraseUngluedSuffix(String phraseUngluedSuffix) {
        this.phraseUngluedSuffix = phraseUngluedSuffix;
        return this;
    }

    public String getPhrase() {
        return phrase;
    }

    public KeywordItemResponse withPhrase(String phrase) {
        this.phrase = phrase;
        return this;
    }

    public List<List<String>> getFixations() {
        return fixations;
    }

    public KeywordItemResponse withFixations(List<List<String>> fixations) {
        this.fixations = fixations;
        return this;
    }

    public Integer getDuplicate() {
        return duplicate;
    }

    public KeywordItemResponse withDuplicate(Integer duplicate) {
        this.duplicate = duplicate;
        return this;
    }

    public Integer getIsSuspended() {
        return isSuspended;
    }

    public KeywordItemResponse withIsSuspended(Integer isSuspended) {
        this.isSuspended = isSuspended;
        return this;
    }

    public String getPrice() {
        return price;
    }

    public KeywordItemResponse withPrice(String price) {
        this.price = price;
        return this;
    }

    public String getPriceContext() {
        return priceContext;
    }

    public KeywordItemResponse withPriceContext(String priceContext) {
        this.priceContext = priceContext;
        return this;
    }

    public String getCtr() {
        return ctr;
    }

    public KeywordItemResponse withCtr(String ctr) {
        this.ctr = ctr;
        return this;
    }

    public Long getShows() {
        return shows;
    }

    public KeywordItemResponse withShows(Long shows) {
        this.shows = shows;
        return this;
    }

    public Long getClicks() {
        return clicks;
    }

    public KeywordItemResponse withClicks(Long clicks) {
        this.clicks = clicks;
        return this;
    }

    public String getPhraseId() {
        return phraseId;
    }

    public KeywordItemResponse withPhraseId(String phraseId) {
        this.phraseId = phraseId;
        return this;
    }

    public String getNormPhrase() {
        return normPhrase;
    }

    public KeywordItemResponse withNormPhrase(String normPhrase) {
        this.normPhrase = normPhrase;
        return this;
    }

    public Integer getWordsCount() {
        return wordsCount;
    }

    public KeywordItemResponse withWordsCount(Integer numWords) {
        this.wordsCount = numWords;
        return this;
    }

    public Map<Integer, TrafficVolumeItem> getTrafficVolume() {
        return trafficVolume;
    }

    public KeywordItemResponse withTrafficVolume(Map<Integer, TrafficVolumeItem> trafficVolume) {
        this.trafficVolume = trafficVolume;
        return this;
    }

    public Map<Integer, String> getPriceForCoverage() {
        return priceForCoverage;
    }

    public KeywordItemResponse withPriceForCoverage(Map<Integer, String> priceForCoverage) {
        this.priceForCoverage = priceForCoverage;
        return this;
    }
}
